/*
 * Decompiled with CFR 0.152.
 */
package plugins.time;

import freemind.controller.actions.generated.instance.TimeWindowColumnSetting;
import freemind.controller.actions.generated.instance.TimeWindowColumnSettingType;
import freemind.controller.actions.generated.instance.TimeWindowConfigurationStorage;
import freemind.controller.actions.generated.instance.TimeWindowConfigurationStorageType;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.extensions.ModeControllerHookAdapter;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.view.mindmapview.MultipleImage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.xml.bind.JAXBException;
import plugins.time.ReminderHook;
import plugins.time.TableSorter;
import plugins.time.TimeManagement;

public class TimeList
extends ModeControllerHookAdapter {
    private static String COLUMN_MODIFIED = "Modified";
    private static String COLUMN_CREATED = "Created";
    private static String COLUMN_ICONS = "Icons";
    private static String COLUMN_TEXT = "Text";
    private static String COLUMN_DATE = "Date";
    private static final int DATE_COLUMN = 0;
    private static final int NODE_TEXT_COLUMN = 1;
    protected static final int NODE_ICON_COLUMN = 2;
    protected static final int NODE_CREATED_COLUMN = 3;
    protected static final int NODE_MODIFIED_COLUMN = 4;
    private JDialog dialog;
    private JPanel timePanel;
    private JTable timeTable;
    private DefaultTableModel timeTableModel;
    private TableSorter sorter;
    private DateRenderer dateRenderer;
    private NodeRenderer nodeRenderer;
    private IconsRenderer iconsRenderer;
    private boolean showAllNodes = false;
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = (class$plugins$time$TimeList == null ? (class$plugins$time$TimeList = TimeList.class$("plugins.time.TimeList")) : class$plugins$time$TimeList).getName() + "_properties";
    static /* synthetic */ Class class$plugins$time$TimeList;
    static /* synthetic */ Class class$java$awt$event$KeyListener;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$freemind$modes$MindMapNode;
    static /* synthetic */ Class class$plugins$time$TimeList$IconsHolder;
    static /* synthetic */ Class class$plugins$time$TimeList$NodeHolder;
    static /* synthetic */ Class class$java$lang$Object;

    public void startupMapHook() {
        super.startupMapHook();
        COLUMN_MODIFIED = this.getResourceString("plugins/TimeList.xml_Modified");
        COLUMN_CREATED = this.getResourceString("plugins/TimeList.xml_Created");
        COLUMN_ICONS = this.getResourceString("plugins/TimeList.xml_Icons");
        COLUMN_TEXT = this.getResourceString("plugins/TimeList.xml_Text");
        COLUMN_DATE = this.getResourceString("plugins/TimeList.xml_Date");
        this.showAllNodes = Tools.xmlToBoolean((String)this.getResourceString("show_all_nodes"));
        this.dialog = new JDialog((Frame)this.getController().getFrame().getJFrame(), true);
        this.dialog.setTitle(this.getResourceString("plugins/TimeManagement.xml_WindowTitle"));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                TimeList.this.disposeDialog();
            }
        });
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                TimeList.this.disposeDialog();
            }
        };
        action.putValue("Name", "end_dialog");
        this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), action.getValue("Name"));
        this.dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
        Container contentPane = this.dialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        GridBagConstraints gb1 = new GridBagConstraints();
        gb1.gridx = 0;
        gb1.gridy = 0;
        gb1.fill = 1;
        this.dateRenderer = new DateRenderer();
        this.nodeRenderer = new NodeRenderer();
        this.iconsRenderer = new IconsRenderer(this.getController());
        this.timeTable = new JTable(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                Object object = this.getModel().getValueAt(row, column);
                if (object instanceof Date) {
                    return TimeList.this.dateRenderer;
                }
                if (object instanceof NodeHolder) {
                    return TimeList.this.nodeRenderer;
                }
                if (object instanceof IconsHolder) {
                    return TimeList.this.iconsRenderer;
                }
                return super.getCellRenderer(row, column);
            }

            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }

            protected void processKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EventListener[] el = super.getListeners(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = TimeList.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener);
                    if (e.getID() != 402) {
                        return;
                    }
                    for (int i = 0; i < el.length; ++i) {
                        KeyListener kl = (KeyListener)el[i];
                        kl.keyReleased(e);
                    }
                    return;
                }
                super.processKeyEvent(e);
            }
        };
        this.timeTable.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
            }

            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 27) {
                    TimeList.this.disposeDialog();
                }
                if (arg0.getKeyCode() == 10) {
                    TimeList.this.gotoNodesAndClose(TimeList.this.timeTable.getSelectedRow(), TimeList.this.timeTable.getSelectedRows());
                }
            }
        });
        this.timeTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Point p = e.getPoint();
                    int row = TimeList.this.timeTable.rowAtPoint(p);
                    TimeList.this.gotoNodesAndClose(row, new int[]{row});
                }
            }
        });
        this.timeTable.getTableHeader().setReorderingAllowed(false);
        this.timeTableModel = this.updateModel();
        this.sorter = new TableSorter(this.timeTableModel);
        this.timeTable.setModel(this.sorter);
        this.sorter.setTableHeader(this.timeTable.getTableHeader());
        this.sorter.setColumnComparator(class$java$util$Date == null ? (class$java$util$Date = TimeList.class$("java.util.Date")) : class$java$util$Date, TableSorter.COMPARABLE_COMAPRATOR);
        this.sorter.setColumnComparator(class$freemind$modes$MindMapNode == null ? (class$freemind$modes$MindMapNode = TimeList.class$("freemind.modes.MindMapNode")) : class$freemind$modes$MindMapNode, TableSorter.LEXICAL_COMPARATOR);
        this.sorter.setColumnComparator(class$plugins$time$TimeList$IconsHolder == null ? (class$plugins$time$TimeList$IconsHolder = TimeList.class$("plugins.time.TimeList$IconsHolder")) : class$plugins$time$TimeList$IconsHolder, TableSorter.COMPARABLE_COMAPRATOR);
        this.sorter.setSortingStatus(0, 1);
        JScrollPane pane = new JScrollPane(this.timeTable);
        contentPane.add((Component)pane, gb1);
        WindowConfigurationStorage storage = this.getController().getController().decorateDialog(this.dialog, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        if (storage != null) {
            this.timeTable.setAutoResizeMode(0);
            int column = 0;
            Iterator i = ((TimeWindowConfigurationStorageType)storage).getTimeWindowColumnSetting().iterator();
            while (i.hasNext()) {
                TimeWindowColumnSettingType setting = (TimeWindowColumnSettingType)i.next();
                this.timeTable.getColumnModel().getColumn(column).setPreferredWidth(setting.getColumnWidth());
                this.sorter.setSortingStatus(column, setting.getColumnSorting());
                ++column;
            }
        }
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void gotoNodesAndClose(int focussedRow, int[] selectedRows) {
        if (focussedRow >= 0) {
            MindMapNode focussedNode = this.getMindMapNode(focussedRow);
            Vector<MindMapNode> selectedNodes = new Vector<MindMapNode>();
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                selectedNodes.add(this.getMindMapNode(row));
            }
            this.getController().selectMultipleNodes(focussedNode, selectedNodes);
            this.disposeDialog();
        }
    }

    private MindMapNode getMindMapNode(int focussedRow) {
        MindMapNode selectedNode = ((NodeHolder)this.timeTable.getModel().getValueAt(focussedRow, 1)).node;
        return selectedNode;
    }

    private DefaultTableModel updateModel() {
        MindMapNode node = (MindMapNode)this.getController().getMap().getRoot();
        DefaultTableModel model = new DefaultTableModel(){

            public Class getColumnClass(int arg0) {
                switch (arg0) {
                    case 0: 
                    case 3: 
                    case 4: {
                        return class$java$util$Date == null ? (class$java$util$Date = TimeList.class$("java.util.Date")) : class$java$util$Date;
                    }
                    case 1: {
                        return class$plugins$time$TimeList$NodeHolder == null ? (class$plugins$time$TimeList$NodeHolder = TimeList.class$("plugins.time.TimeList$NodeHolder")) : class$plugins$time$TimeList$NodeHolder;
                    }
                    case 2: {
                        return class$plugins$time$TimeList$IconsHolder == null ? (class$plugins$time$TimeList$IconsHolder = TimeList.class$("plugins.time.TimeList$IconsHolder")) : class$plugins$time$TimeList$IconsHolder;
                    }
                }
                return class$java$lang$Object == null ? (class$java$lang$Object = TimeList.class$("java.lang.Object")) : class$java$lang$Object;
            }
        };
        model.addColumn(COLUMN_DATE);
        model.addColumn(COLUMN_TEXT);
        model.addColumn(COLUMN_ICONS);
        model.addColumn(COLUMN_CREATED);
        model.addColumn(COLUMN_MODIFIED);
        model.setColumnIdentifiers(new Object[]{COLUMN_DATE, COLUMN_TEXT, COLUMN_ICONS, COLUMN_CREATED, COLUMN_MODIFIED});
        this.updateModel(model, node);
        return model;
    }

    private void updateModel(DefaultTableModel model, MindMapNode node) {
        ReminderHook hook = TimeManagement.getHook(node);
        Date date = null;
        if (hook != null) {
            date = new Date(hook.getRemindUserAt());
        }
        if (this.showAllNodes || hook != null) {
            model.addRow(new Object[]{date, new NodeHolder(node), new IconsHolder(node), node.getHistoryInformation().getCreatedAt(), node.getHistoryInformation().getLastModifiedAt()});
        }
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.updateModel(model, child);
        }
    }

    private JPanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new JPanel();
            this.timePanel.setLayout(new GridBagLayout());
        }
        return this.timePanel;
    }

    private void disposeDialog() {
        try {
            TimeWindowConfigurationStorage storage = this.getController().getActionXmlFactory().createTimeWindowConfigurationStorage();
            for (int i = 0; i < this.timeTable.getColumnCount(); ++i) {
                TimeWindowColumnSetting setting = this.getController().getActionXmlFactory().createTimeWindowColumnSetting();
                setting.setColumnWidth(this.timeTable.getColumnModel().getColumn(i).getWidth());
                setting.setColumnSorting(this.sorter.getSortingStatus(i));
                storage.getTimeWindowColumnSetting().add(setting);
            }
            this.getController().getController().storeDialogPositions(this.dialog, (WindowConfigurationStorage)storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class IconsRenderer
    extends DefaultTableCellRenderer {
        private final ModeController modeController;

        public IconsRenderer(ModeController controller) {
            this.modeController = controller;
        }

        public void setValue(Object value) {
            if (value instanceof IconsHolder) {
                IconsHolder iconsHolder = (IconsHolder)value;
                MultipleImage iconImages = new MultipleImage(1.0);
                Iterator i = iconsHolder.getIcons().iterator();
                while (i.hasNext()) {
                    MindIcon icon = (MindIcon)i.next();
                    iconImages.addImage(icon.getIcon(this.modeController.getFrame()));
                }
                if (iconImages.getImageCount() > 0) {
                    this.setIcon((Icon)iconImages);
                } else {
                    this.setIcon(null);
                }
            }
        }
    }

    static class IconsHolder
    implements Comparable {
        Vector icons = new Vector();
        private Vector iconNames;

        public IconsHolder(MindMapNode node) {
            this.icons.addAll(node.getIcons());
            this.iconNames = new Vector();
            Iterator i = this.icons.iterator();
            while (i.hasNext()) {
                MindIcon icon = (MindIcon)i.next();
                this.iconNames.add(icon.getName());
            }
            Collections.sort(this.iconNames);
        }

        public int compareTo(Object compareToObject) {
            return this.toString().compareTo(compareToObject.toString());
        }

        public Vector getIcons() {
            return this.icons;
        }

        public String toString() {
            String result = "";
            Iterator i = this.iconNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                result = result + name + " ";
            }
            return result;
        }
    }

    static class NodeHolder
    implements Comparable {
        private final MindMapNode node;

        public NodeHolder(MindMapNode node) {
            this.node = node;
        }

        public int compareTo(Object compareToObject) {
            return this.toString().compareTo(compareToObject.toString());
        }

        public String toString() {
            String text = this.node.getText();
            if (text.toLowerCase().matches("^\\s*<html>")) {
                text = text.replaceAll("<[^>]*>", "");
            }
            return text;
        }
    }

    static class NodeRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object value) {
            this.setText(value == null ? "" : ((NodeHolder)value).node.getText());
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateTimeInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }
}

