/*
 * Decompiled with CFR 0.152.
 */
package plugins.time;

import com.toedter.calendar.JCalendar;
import freemind.extensions.ModeControllerHookAdapter;
import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.modes.MindMapNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import plugins.time.ReminderHook;

public class TimeManagement
extends ModeControllerHookAdapter
implements PropertyChangeListener,
ActionListener {
    public static final String REMINDER_HOOK_NAME = "plugins/TimeManagementReminder.xml";
    private static Date lastDate = null;
    private JCalendar calendar;
    private JDialog dialog;
    private JPanel timePanel;
    private JTextField hourField;
    private JTextField minuteField;

    public void startupMapHook() {
        super.startupMapHook();
        this.dialog = new JDialog((Frame)this.getController().getFrame().getJFrame(), true);
        this.dialog.setTitle(this.getResourceString("plugins/TimeManagement.xml_WindowTitle"));
        this.dialog.setDefaultCloseOperation(2);
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                TimeManagement.this.disposeDialog();
            }
        };
        action.putValue("Name", "end_dialog");
        this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), action.getValue("Name"));
        this.dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
        this.calendar = new JCalendar();
        if (lastDate != null) {
            this.calendar.setDate(lastDate);
        }
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gb1 = new GridBagConstraints();
        gb1.gridx = 0;
        gb1.gridwidth = 4;
        gb1.fill = 1;
        gb1.gridy = 0;
        this.calendar.getDayChooser().addPropertyChangeListener((PropertyChangeListener)this);
        contentPane.add((Component)this.calendar, gb1);
        GridBagConstraints gb2 = new GridBagConstraints();
        gb2.gridx = 0;
        gb2.gridy = 1;
        gb2.gridwidth = 4;
        gb2.fill = 2;
        contentPane.add((Component)this.getTimePanel(), gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 0;
        gb2.gridy = 2;
        gb2.fill = 2;
        JButton appendButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_appendButton"));
        appendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TimeManagement.this.disposeDialog();
                Iterator i = TimeManagement.this.getController().getSelecteds().iterator();
                while (i.hasNext()) {
                    MindMapNode element = (MindMapNode)i.next();
                    DateFormat df = DateFormat.getDateInstance(3);
                    String dateAsString = df.format(TimeManagement.this.getCalendarDate());
                    TimeManagement.this.getController().setNodeText(element, element.getText() + " " + dateAsString);
                }
            }
        });
        contentPane.add((Component)appendButton, gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 1;
        gb2.gridy = 2;
        gb2.fill = 2;
        JButton reminderButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_reminderButton"));
        reminderButton.setToolTipText(this.getResourceString("plugins/TimeManagement.xml_reminderButton_tooltip"));
        reminderButton.addActionListener(this);
        contentPane.add((Component)reminderButton, gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 2;
        gb2.gridy = 2;
        gb2.fill = 2;
        reminderButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_removeReminderButton"));
        reminderButton.setToolTipText(this.getResourceString("plugins/TimeManagement.xml_removeReminderButton_tooltip"));
        reminderButton.addActionListener(new RemoveReminders());
        contentPane.add((Component)reminderButton, gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 3;
        gb2.gridy = 2;
        gb2.fill = 2;
        JButton todayButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_todayButton"));
        todayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TimeManagement.this.calendar.setCalendar(Calendar.getInstance());
            }
        });
        contentPane.add((Component)todayButton, gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 4;
        gb2.gridy = 2;
        gb2.fill = 2;
        JButton cancelButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_cancelButton"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                TimeManagement.this.disposeDialog();
            }
        });
        contentPane.add((Component)cancelButton, gb2);
        this.dialog.pack();
        this.dialog.setVisible(true);
        this.calendar.getDayChooser().setFocus();
    }

    private JPanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new JPanel();
            this.timePanel.setLayout(new GridBagLayout());
            GridBagConstraints gb2 = new GridBagConstraints();
            gb2.gridx = 0;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.timePanel.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_hour")), gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 1;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.hourField = new JTextField(2);
            this.hourField.setText(new Integer(this.calendar.getCalendar().get(11)).toString());
            this.timePanel.add((Component)this.hourField, gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 2;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.timePanel.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_minute")), gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 3;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.minuteField = new JTextField(2);
            String minuteString = new Integer(this.calendar.getCalendar().get(12)).toString();
            if (minuteString.length() < 2) {
                minuteString = "0" + minuteString;
            }
            this.minuteField.setText(minuteString);
            this.timePanel.add((Component)this.minuteField, gb2);
        }
        return this.timePanel;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("day")) {
            // empty if block
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        Date date = this.getCalendarDate();
        Iterator i = this.getController().getSelecteds().iterator();
        while (i.hasNext()) {
            MindMapNode node = (MindMapNode)i.next();
            ReminderHook alreadyPresentHook = TimeManagement.getHook(node);
            if (alreadyPresentHook != null) {
                Object[] messageArguments = new Object[]{new Date(alreadyPresentHook.getRemindUserAt()), date};
                MessageFormat formatter = new MessageFormat(this.getResourceString("plugins/TimeManagement.xml_reminderNode_onlyOneDate"));
                String message = formatter.format(messageArguments);
                this.logger.info(messageArguments.length + ", " + message);
                int result = JOptionPane.showConfirmDialog(this.getController().getFrame().getJFrame(), message, "FreeMind", 0);
                if (result == 1) {
                    return;
                }
                this.addHook(node);
            }
            this.addHook(node);
            ReminderHook rh = TimeManagement.getHook(node);
            if (rh == null) {
                throw new IllegalArgumentException("hook not found although it is present!!");
            }
            rh.setRemindUserAt(date.getTime());
            node.invokeHook((NodeHook)rh);
            this.getController().nodeChanged(node);
        }
        this.disposeDialog();
    }

    private void addHook(MindMapNode node) {
        List<MindMapNode> selected = Arrays.asList(node);
        this.getController().addHook(node, selected, REMINDER_HOOK_NAME);
    }

    public static ReminderHook getHook(MindMapNode node) {
        Iterator j = node.getActivatedHooks().iterator();
        while (j.hasNext()) {
            PermanentNodeHook element = (PermanentNodeHook)j.next();
            if (!(element instanceof ReminderHook)) continue;
            return (ReminderHook)element;
        }
        return null;
    }

    private void disposeDialog() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        lastDate = this.getCalendarDate();
    }

    private Date getCalendarDate() {
        Calendar cal = this.calendar.getCalendar();
        try {
            int value = 0;
            value = Integer.parseInt(this.hourField.getText());
            cal.set(11, value);
            value = Integer.parseInt(this.minuteField.getText());
            cal.set(12, value);
            cal.set(13, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cal.getTime();
    }

    private final class RemoveReminders
    implements ActionListener {
        private RemoveReminders() {
        }

        public void actionPerformed(ActionEvent e) {
            Iterator i = TimeManagement.this.getController().getSelecteds().iterator();
            while (i.hasNext()) {
                MindMapNode node = (MindMapNode)i.next();
                ReminderHook alreadyPresentHook = TimeManagement.getHook(node);
                if (alreadyPresentHook == null) continue;
                TimeManagement.this.addHook(node);
            }
        }
    }
}

