/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Map;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontReader;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;

public class LazyFont
extends Typeface
implements FontDescriptor {
    private String metricsFileName = null;
    private String fontEmbedPath = null;
    private boolean useKerning = false;
    private boolean isMetricsLoaded = false;
    private Typeface realFont = null;
    private FontDescriptor realFontDescriptor = null;

    public LazyFont(String fontEmbedPath, String metricsFileName, boolean useKerning) {
        this.metricsFileName = metricsFileName;
        this.fontEmbedPath = fontEmbedPath;
        this.useKerning = useKerning;
    }

    public int getAscender() {
        this.load();
        return this.realFontDescriptor.getAscender();
    }

    public int getAscender(int size) {
        this.load();
        return this.realFont.getAscender(size);
    }

    public int getCapHeight() {
        this.load();
        return this.realFontDescriptor.getCapHeight();
    }

    public int getCapHeight(int size) {
        this.load();
        return this.realFont.getCapHeight(size);
    }

    public int getDescender() {
        this.load();
        return this.realFontDescriptor.getDescender();
    }

    public int getDescender(int size) {
        this.load();
        return this.realFont.getDescender(size);
    }

    public String getEncoding() {
        this.load();
        return this.realFont.getEncoding();
    }

    public int getFlags() {
        this.load();
        return this.realFontDescriptor.getFlags();
    }

    public int[] getFontBBox() {
        this.load();
        return this.realFontDescriptor.getFontBBox();
    }

    public String getFontName() {
        this.load();
        return this.realFont.getFontName();
    }

    public FontType getFontType() {
        this.load();
        return this.realFontDescriptor.getFontType();
    }

    public int getItalicAngle() {
        this.load();
        return this.realFontDescriptor.getItalicAngle();
    }

    public Map getKerningInfo() {
        this.load();
        return this.realFont.getKerningInfo();
    }

    public Typeface getRealFont() {
        this.load();
        return this.realFont;
    }

    public int getStemV() {
        this.load();
        return this.realFontDescriptor.getStemV();
    }

    public int getWidth(int i, int size) {
        this.load();
        return this.realFont.getWidth(i, size);
    }

    public int[] getWidths() {
        this.load();
        return this.realFont.getWidths();
    }

    public int getXHeight(int size) {
        this.load();
        return this.realFont.getXHeight(size);
    }

    public boolean hasKerningInfo() {
        this.load();
        return this.realFont.hasKerningInfo();
    }

    public boolean isEmbeddable() {
        this.load();
        return this.realFontDescriptor.isEmbeddable();
    }

    public boolean isMultiByte() {
        return this.realFont.isMultiByte();
    }

    private void load() {
        block3: {
            if (this.isMetricsLoaded) break block3;
            this.isMetricsLoaded = true;
            try {
                FontReader reader = new FontReader(this.metricsFileName);
                reader.setKerningEnabled(this.useKerning);
                reader.setFontEmbedPath(this.fontEmbedPath);
                this.realFont = reader.getFont();
                if (this.realFont instanceof FontDescriptor) {
                    this.realFontDescriptor = (FontDescriptor)((Object)this.realFont);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public char mapChar(char c) {
        this.load();
        return this.realFont.mapChar(c);
    }
}

