/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLReader
implements ImageReader {
    private static Map converters = new HashMap();

    public FopImage.ImageInfo createDocument(InputStream is, FOUserAgent ua) {
        Document doc = null;
        FopImage.ImageInfo info = new FopImage.ImageInfo();
        info.mimeType = this.getMimeType();
        try {
            FopImage.ImageInfo i;
            String ns;
            int length = is.available();
            is.mark(length);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            doc = dbf.newDocumentBuilder().parse(is);
            info.data = doc;
            Element root = doc.getDocumentElement();
            ua.getLogger().debug("XML image namespace: " + root.getAttribute("xmlns"));
            info.str = ns = root.getAttribute("xmlns");
            Converter conv = (Converter)converters.get(ns);
            if (conv != null && (i = conv.convert(doc)) != null) {
                info = i;
            }
        }
        catch (Exception e) {
            ua.getLogger().warn("Error while constructing image from XML", e);
            try {
                is.reset();
            }
            catch (IOException iOException) {}
            return null;
        }
        return info;
    }

    public String getMimeType() {
        return "text/xml";
    }

    protected FopImage.ImageInfo loadImage(String uri, InputStream bis, FOUserAgent ua) {
        return this.createDocument(bis, ua);
    }

    public static void setConverter(String ns, Converter conv) {
        converters.put(ns, conv);
    }

    public FopImage.ImageInfo verifySignature(String uri, InputStream fis, FOUserAgent ua) throws IOException {
        FopImage.ImageInfo info;
        block2: {
            info = this.loadImage(uri, fis, ua);
            if (info == null) break block2;
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return info;
    }

    public static interface Converter {
        public FopImage.ImageInfo convert(Document var1);
    }
}

