/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPathPaint;

public class PDFColor
extends PDFPathPaint {
    private static double blackFactor = 2.0;
    private double red = -1.0;
    private double green = -1.0;
    private double blue = -1.0;
    private double cyan = -1.0;
    private double magenta = -1.0;
    private double yellow = -1.0;
    private double black = -1.0;

    public PDFColor(double theRed, double theGreen, double theBlue) {
        this.colorSpace = new PDFColorSpace(2);
        this.red = theRed;
        this.green = theGreen;
        this.blue = theBlue;
    }

    public PDFColor(double theCyan, double theMagenta, double theYellow, double theBlack) {
        this.colorSpace = new PDFColorSpace(3);
        this.cyan = theCyan;
        this.magenta = theMagenta;
        this.yellow = theYellow;
        this.black = theBlack;
    }

    public PDFColor(int theRed, int theGreen, int theBlue) {
        this((double)theRed / 255.0, (double)theGreen / 255.0, (double)theBlue / 255.0);
    }

    public double black() {
        return this.black;
    }

    public double blue() {
        return this.blue;
    }

    public int blue255() {
        return (int)(this.blue * 255.0);
    }

    protected void convertCMYKtoGRAY() {
        double tempDouble = 0.0;
        tempDouble = this.cyan;
        if (this.magenta < tempDouble) {
            tempDouble = this.magenta;
        }
        if (this.yellow < tempDouble) {
            tempDouble = this.yellow;
        }
        this.black = tempDouble / blackFactor;
    }

    protected void convertCMYKtoRGB() {
        this.red = 1.0 - this.cyan;
        this.green = 1.0 - this.green;
        this.blue = 1.0 - this.yellow;
        this.red = this.black / blackFactor + this.red;
        this.green = this.black / blackFactor + this.green;
        this.blue = this.black / blackFactor + this.blue;
    }

    protected void convertGRAYtoCMYK() {
        this.cyan = this.black;
        this.magenta = this.black;
        this.yellow = this.black;
    }

    protected void convertGRAYtoRGB() {
        this.red = 1.0 - this.black;
        this.green = 1.0 - this.black;
        this.blue = 1.0 - this.black;
    }

    protected void convertRGBtoCMYK() {
        this.cyan = 1.0 - this.red;
        this.magenta = 1.0 - this.green;
        this.yellow = 1.0 - this.blue;
        this.black = 0.0;
    }

    protected void convertRGBtoGRAY() {
        double tempDouble = 0.0;
        tempDouble = this.red;
        if (this.green < tempDouble) {
            tempDouble = this.green;
        }
        if (this.blue < tempDouble) {
            tempDouble = this.blue;
        }
        this.black = 1.0 - tempDouble / blackFactor;
    }

    public double cyan() {
        return this.cyan;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PDFColor)) {
            return false;
        }
        PDFColor color = (PDFColor)obj;
        return color.red == this.red && color.green == this.green && color.blue == this.blue;
    }

    public String getColorSpaceOut(boolean fillNotStroke) {
        StringBuffer p = new StringBuffer("");
        if (this.colorSpace.getColorSpace() == 2) {
            boolean same = false;
            if (this.red == this.green && this.red == this.blue) {
                same = true;
            }
            if (fillNotStroke) {
                if (same) {
                    p.append(String.valueOf(PDFNumber.doubleOut(this.red)) + " g\n");
                } else {
                    p.append(String.valueOf(PDFNumber.doubleOut(this.red)) + " " + PDFNumber.doubleOut(this.green) + " " + PDFNumber.doubleOut(this.blue) + " rg\n");
                }
            } else if (same) {
                p.append(String.valueOf(PDFNumber.doubleOut(this.red)) + " G\n");
            } else {
                p.append(String.valueOf(PDFNumber.doubleOut(this.red)) + " " + PDFNumber.doubleOut(this.green) + " " + PDFNumber.doubleOut(this.blue) + " RG\n");
            }
        } else if (this.colorSpace.getColorSpace() == 3) {
            if (fillNotStroke) {
                p.append(String.valueOf(PDFNumber.doubleOut(this.cyan)) + " " + PDFNumber.doubleOut(this.magenta) + " " + PDFNumber.doubleOut(this.yellow) + " " + PDFNumber.doubleOut(this.black) + " k\n");
            } else {
                p.append(String.valueOf(PDFNumber.doubleOut(this.cyan)) + " " + PDFNumber.doubleOut(this.magenta) + " " + PDFNumber.doubleOut(this.yellow) + " " + PDFNumber.doubleOut(this.black) + " K\n");
            }
        } else if (fillNotStroke) {
            p.append(String.valueOf(PDFNumber.doubleOut(this.black)) + " g\n");
        } else {
            p.append(String.valueOf(PDFNumber.doubleOut(this.black)) + " G\n");
        }
        return p.toString();
    }

    public List getVector() {
        ArrayList<Double> theColorVector = new ArrayList<Double>();
        if (this.colorSpace.getColorSpace() == 2) {
            theColorVector.add(new Double(this.red));
            theColorVector.add(new Double(this.green));
            theColorVector.add(new Double(this.blue));
        } else if (this.colorSpace.getColorSpace() == 3) {
            theColorVector.add(new Double(this.cyan));
            theColorVector.add(new Double(this.magenta));
            theColorVector.add(new Double(this.yellow));
            theColorVector.add(new Double(this.black));
        } else {
            theColorVector.add(new Double(this.black));
        }
        return theColorVector;
    }

    public double green() {
        return this.green;
    }

    public int green255() {
        return (int)(this.green * 255.0);
    }

    public double magenta() {
        return this.magenta;
    }

    public double red() {
        return this.red;
    }

    public int red255() {
        return (int)(this.red * 255.0);
    }

    public void setColorSpace(int theColorSpace) {
        int theOldColorSpace = this.colorSpace.getColorSpace();
        if (theOldColorSpace != theColorSpace) {
            if (theOldColorSpace == 2) {
                if (theColorSpace == 3) {
                    this.convertRGBtoCMYK();
                } else {
                    this.convertRGBtoGRAY();
                }
            } else if (theOldColorSpace == 3) {
                if (theColorSpace == 2) {
                    this.convertCMYKtoRGB();
                } else {
                    this.convertCMYKtoGRAY();
                }
            } else if (theColorSpace == 2) {
                this.convertGRAYtoRGB();
            } else {
                this.convertGRAYtoCMYK();
            }
            this.colorSpace.setColorSpace(theColorSpace);
        }
    }

    public byte[] toPDF() {
        return new byte[0];
    }

    public double yellow() {
        return this.yellow;
    }
}

