/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.fop.pdf.PDFObject;

public class PDFInfo
extends PDFObject {
    private String producer;
    private String title = null;
    private String author = null;
    private String subject = null;
    private String keywords = null;
    private Date creationDate = null;
    private String creator;

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setAuthor(String a) {
        this.author = a;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setKeywords(String k) {
        this.keywords = k;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public byte[] toPDF() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(128);
        try {
            bout.write(PDFObject.encode(this.getObjectID()));
            bout.write(PDFObject.encode("<< /Type /Info\n"));
            if (this.title != null) {
                bout.write(PDFObject.encode("/Title "));
                bout.write(this.encodeText(this.title));
                bout.write(PDFObject.encode("\n"));
            }
            if (this.author != null) {
                bout.write(PDFObject.encode("/Author "));
                bout.write(this.encodeText(this.author));
                bout.write(PDFObject.encode("\n"));
            }
            if (this.subject != null) {
                bout.write(PDFObject.encode("/Subject "));
                bout.write(this.encodeText(this.subject));
                bout.write(PDFObject.encode("\n"));
            }
            if (this.keywords != null) {
                bout.write(PDFObject.encode("/Keywords "));
                bout.write(this.encodeText(this.keywords));
                bout.write(PDFObject.encode("\n"));
            }
            if (this.creator != null) {
                bout.write(PDFObject.encode("/Creator "));
                bout.write(this.encodeText(this.creator));
                bout.write(PDFObject.encode("\n"));
            }
            bout.write(PDFObject.encode("/Producer "));
            bout.write(this.encodeText(this.producer));
            bout.write(PDFObject.encode("\n"));
            if (this.creationDate == null) {
                this.creationDate = new Date();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String str = String.valueOf(sdf.format(this.creationDate)) + "+00'00'";
            bout.write(PDFObject.encode("/CreationDate "));
            bout.write(this.encodeString("D:" + str));
            bout.write(PDFObject.encode("\n>>\nendobj\n"));
        }
        catch (IOException ioe) {
            this.getDocumentSafely().getLogger().error("Ignored I/O exception", ioe);
        }
        return bout.toByteArray();
    }
}

