/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fop.apps.Document;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FOTreeControl;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSProcSets;
import org.apache.fop.render.ps.PSXMLHandler;
import org.apache.fop.traits.BorderProps;

public class PSRenderer
extends AbstractRenderer {
    public static final String MIME_TYPE = "application/postscript";
    private int currentPageNumber = 0;
    private boolean enableComments = true;
    private boolean autoRotateLandscape = false;
    protected PSGenerator gen;
    private boolean ioTrouble = false;
    private String currentFontName;
    private int currentFontSize;
    private float currRed;
    private float currGreen;
    private float currBlue;
    private Document fontInfo;

    protected void beginTextObject() {
        this.writeln("BT");
    }

    protected void clip(float x, float y, float width, float height) {
        this.writeln(String.valueOf(x) + " " + y + " " + width + " " + height + " rectclip");
    }

    protected void comment(String comment) {
        if (this.enableComments) {
            this.writeln(comment);
        }
    }

    protected void concatMatrix(double a, double b, double c, double d, double e, double f) {
        try {
            this.gen.concatMatrix(a, b, c, d, e, f);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double[] matrix) {
        try {
            this.gen.concatMatrix(matrix);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        super.configure(cfg);
        this.autoRotateLandscape = cfg.getChild("auto-rotate-landscape").getValueAsBoolean(false);
    }

    protected void drawBackAndBorders(Area block, float startx, float starty, float width, float height) {
        float bwidth;
        BorderProps bps;
        boolean started = false;
        Trait.Background back = (Trait.Background)block.getTrait((Object)Trait.BACKGROUND);
        if (back != null) {
            ImageFactory fact;
            FopImage fopimage;
            started = true;
            this.endTextObject();
            if (back.getColor() != null) {
                this.updateColor(back.getColor(), true, null);
                this.writeln(String.valueOf(startx) + " " + starty + " " + width + " " + height + " rectfill");
            }
            if (back.getURL() != null && (fopimage = (fact = ImageFactory.getInstance()).getImage(back.getURL(), this.userAgent)) != null && fopimage.load(1, this.userAgent) && back.getRepeat() != 74) {
                Rectangle2D.Float float_ = new Rectangle2D.Float((startx + (float)back.getHoriz()) * 1000.0f, (starty + (float)back.getVertical()) * 1000.0f, fopimage.getWidth() * 1000, fopimage.getHeight() * 1000);
            }
        }
        if ((bps = (BorderProps)block.getTrait((Object)Trait.BORDER_BEFORE)) != null) {
            float endx = startx + width;
            if (!started) {
                started = true;
                this.endTextObject();
            }
            float bwidth2 = bps.width;
            this.updateColor(bps.color, false, null);
            this.writeln(String.valueOf(bwidth2) + " setlinewidth");
            this.drawLine(startx, starty + bwidth2 / 2.0f, endx, starty + bwidth2 / 2.0f);
        }
        if ((bps = (BorderProps)block.getTrait((Object)Trait.BORDER_START)) != null) {
            float endy = starty + height;
            if (!started) {
                started = true;
                this.endTextObject();
            }
            float bwidth3 = bps.width;
            this.updateColor(bps.color, false, null);
            this.writeln(String.valueOf(bwidth3) + " setlinewidth");
            this.drawLine(startx + bwidth3 / 2.0f, starty, startx + bwidth3 / 2.0f, endy);
        }
        if ((bps = (BorderProps)block.getTrait((Object)Trait.BORDER_AFTER)) != null) {
            float sy = starty + height;
            float endx = startx + width;
            if (!started) {
                started = true;
                this.endTextObject();
            }
            bwidth = bps.width;
            this.updateColor(bps.color, false, null);
            this.writeln(String.valueOf(bwidth) + " setlinewidth");
            this.drawLine(startx, sy - bwidth / 2.0f, endx, sy - bwidth / 2.0f);
        }
        if ((bps = (BorderProps)block.getTrait((Object)Trait.BORDER_END)) != null) {
            float sx = startx + width;
            float endy = starty + height;
            if (!started) {
                started = true;
                this.endTextObject();
            }
            bwidth = bps.width;
            this.updateColor(bps.color, false, null);
            this.writeln(String.valueOf(bwidth) + " setlinewidth");
            this.drawLine(sx - bwidth / 2.0f, starty, sx - bwidth / 2.0f, endy);
        }
        if (started) {
            this.beginTextObject();
            this.currentFontName = "";
        }
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.writeln(String.valueOf(startx) + " " + starty + " M ");
        this.writeln(String.valueOf(endx) + " " + endy + " lineto");
    }

    protected void drawRect(int x, int y, int w, int h) {
        this.writeln(String.valueOf(x) + " " + y + " " + w + " " + h + " rectstroke");
    }

    protected void endTextObject() {
        this.writeln("ET");
    }

    protected void endVParea() {
        this.endTextObject();
        this.restoreGraphicsState();
    }

    protected void fillRect(int x, int y, int w, int h, ColorType col) {
        this.useColor(col);
        this.writeln(String.valueOf(x) + " " + y + " " + w + " " + h + " rectfill");
    }

    protected void handleBlockTraits(Block block) {
        float startx = this.currentIPPosition;
        float starty = this.currentBPPosition;
        this.drawBackAndBorders((Area)block, startx, starty, block.getWidth(), block.getHeight());
    }

    protected void handleIOTrouble(IOException ioe) {
        if (!this.ioTrouble) {
            ((AbstractLogEnabled)((Object)this)).getLogger().error("Error while writing to target file", ioe);
            this.ioTrouble = true;
        }
    }

    protected void handleRegionTraits(RegionViewport region) {
        this.currentFontName = "";
        float startx = 0.0f;
        float starty = 0.0f;
        Rectangle2D viewArea = region.getViewArea();
        float width = (float)viewArea.getWidth();
        float height = (float)viewArea.getHeight();
        this.drawBackAndBorders((Area)region, startx, starty, width, height);
    }

    protected void moveTo(int x, int y) {
        this.writeln(String.valueOf(x) + " " + y + " M");
    }

    protected void movetoCurrPosition() {
        this.moveTo(this.currentIPPosition, this.currentBPPosition);
    }

    protected void paintText(int rx, int bl, String text, Typeface font) {
        this.saveGraphicsState();
        this.writeln("1 0 0 -1 " + rx + " " + bl + " Tm");
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        sb.append("(");
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            char mapped = font.mapChar(c);
            PSGenerator.escapeChar(mapped, sb);
            ++i;
        }
        sb.append(") t");
        this.writeln(sb.toString());
        this.restoreGraphicsState();
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        String saveFontName = this.currentFontName;
        CTM ctm = bv.getCTM();
        if (bv.getPositioning() == 2) {
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.endTextObject();
            if (bv.getClip()) {
                this.saveGraphicsState();
                int x = bv.getXOffset() + this.containingIPPosition;
                int y = bv.getYOffset() + this.containingBPPosition;
                int width = bv.getWidth();
                int height = bv.getHeight();
                this.clip(x, y, width, height);
            }
            CTM tempctm = new CTM((double)this.containingIPPosition, (double)this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            this.startVParea(ctm);
            this.handleBlockTraits((Block)bv);
            this.renderBlocks(children);
            this.endVParea();
            if (bv.getClip()) {
                this.restoreGraphicsState();
            }
            this.beginTextObject();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            if (ctm != null) {
                this.currentIPPosition = 0;
                this.currentBPPosition = 0;
                this.endTextObject();
                double[] vals = ctm.toArray();
                ctm = vals[2] == 1.0 ? ctm.translate((double)(-saveBP - bv.getHeight()), (double)(-saveIP)) : (vals[0] == -1.0 ? ctm.translate((double)(-saveIP - bv.getWidth()), (double)(-saveBP - bv.getHeight())) : ctm.translate((double)saveBP, (double)(saveIP - bv.getWidth())));
            }
            if (bv.getClip()) {
                if (ctm == null) {
                    this.endTextObject();
                }
                this.saveGraphicsState();
                int x = bv.getXOffset();
                int y = bv.getYOffset();
                int width = bv.getWidth();
                int height = bv.getHeight();
                this.clip(x, y, width, height);
            }
            if (ctm != null) {
                this.startVParea(ctm);
            }
            this.handleBlockTraits((Block)bv);
            this.renderBlocks(children);
            if (ctm != null) {
                this.endVParea();
            }
            if (bv.getClip()) {
                this.restoreGraphicsState();
                if (ctm == null) {
                    this.beginTextObject();
                }
            }
            if (ctm != null) {
                this.beginTextObject();
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getHeight();
        }
        this.currentFontName = saveFontName;
    }

    public void renderDocument(org.w3c.dom.Document doc, String ns, Rectangle2D pos) {
        RendererContext context = new RendererContext(MIME_TYPE);
        context.setUserAgent(this.userAgent);
        context.setProperty("psGenerator", (Object)this.gen);
        context.setProperty("psFontInfo", (Object)this.fontInfo);
        context.setProperty("width", (Object)new Integer((int)pos.getWidth()));
        context.setProperty("height", (Object)new Integer((int)pos.getHeight()));
        context.setProperty("xpos", (Object)new Integer(this.currentBlockIPPosition + (int)pos.getX()));
        context.setProperty("ypos", (Object)new Integer(this.currentBPPosition + (int)pos.getY()));
        this.renderXML(this.userAgent, context, doc, ns);
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        org.w3c.dom.Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        ((AbstractLogEnabled)((Object)this)).getLogger().debug("renderPage(): " + page);
        ++this.currentPageNumber;
        this.gen.writeDSCComment("Page", new Object[]{page.getPageNumber(), new Integer(this.currentPageNumber)});
        Integer zero = new Integer(0);
        long pagewidth = Math.round(page.getViewArea().getWidth());
        long pageheight = Math.round(page.getViewArea().getHeight());
        double pspagewidth = (float)pagewidth / 1000.0f;
        double pspageheight = (float)pageheight / 1000.0f;
        boolean rotate = false;
        if (this.autoRotateLandscape && pageheight < pagewidth) {
            rotate = true;
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pspageheight)), new Long(Math.round(pspagewidth))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pspageheight), new Double(pspagewidth)});
            this.gen.writeDSCComment("PageOrientation", "Landscape");
        } else {
            this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, new Long(Math.round(pspagewidth)), new Long(Math.round(pspageheight))});
            this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{zero, zero, new Double(pspagewidth), new Double(pspageheight)});
            if (this.autoRotateLandscape) {
                this.gen.writeDSCComment("PageOrientation", "Portrait");
            }
        }
        this.gen.writeDSCComment("BeginPageSetup");
        if (rotate) {
            this.gen.writeln(String.valueOf(Math.round(pspageheight)) + " 0 translate");
            this.gen.writeln("90 rotate");
        }
        this.gen.writeln("0.001 0.001 scale");
        this.concatMatrix(1.0, 0.0, 0.0, -1.0, 0.0, pageheight);
        this.gen.writeDSCComment("EndPageSetup");
        super.renderPage(page);
        this.writeln("showpage");
        this.gen.writeDSCComment("PageTrailer");
        this.gen.writeDSCComment("EndPage");
    }

    public void renderText(TextArea area) {
        String fontname = (String)area.getTrait((Object)Trait.FONT_NAME);
        int fontsize = area.getTraitAsInteger((Object)Trait.FONT_SIZE);
        Typeface f = (Typeface)this.fontInfo.getFonts().get(fontname);
        int rx = this.currentBlockIPPosition;
        int bl = this.currentBPPosition + area.getOffset();
        this.useFont(fontname, fontsize);
        this.paintText(rx, bl, area.getTextArea(), f);
        super.renderText(area);
    }

    public void restoreGraphicsState() {
        try {
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void saveGraphicsState() {
        try {
            this.gen.saveGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        PSXMLHandler xmlHandler = new PSXMLHandler();
        String svg = "http://www.w3.org/2000/svg";
        this.addXMLHandler(this.userAgent, MIME_TYPE, svg, xmlHandler);
    }

    public void setupFontInfo(FOTreeControl foTreeControl) {
        FontSetup.setup((Document)foTreeControl, null);
        this.fontInfo = this.fontInfo;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        ((AbstractLogEnabled)((Object)this)).getLogger().debug("rendering areas to PostScript");
        this.gen = new PSGenerator(outputStream);
        this.currentPageNumber = 0;
        this.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", new String[]{"FOP " + this.producer});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("Pages", new Object[]{PSGenerator.ATEND});
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
        this.gen.writeDSCComment("BeginProlog");
        this.gen.writeDSCComment("EndProlog");
        this.gen.writeDSCComment("BeginSetup");
        PSProcSets.writeFOPStdProcSet(this.gen);
        PSProcSets.writeFOPEPSProcSet(this.gen);
        PSProcSets.writeFontDict(this.gen, this.fontInfo);
        this.gen.writeln("FOPFonts begin");
        this.gen.writeDSCComment("EndSetup");
    }

    protected void startVParea(CTM ctm) {
        this.saveGraphicsState();
        double[] matrix = ctm.toArray();
        this.concatMatrix(matrix);
        this.beginTextObject();
    }

    public void stopRenderer() throws IOException {
        this.gen.writeDSCComment("Trailer");
        this.gen.writeDSCComment("Pages", new Integer(this.currentPageNumber));
        this.gen.writeDSCComment("EOF");
        this.gen.flush();
    }

    private void updateColor(ColorType col, boolean fill, StringBuffer pdf) {
        this.writeln(String.valueOf(this.gen.formatDouble(col.getRed())) + " " + this.gen.formatDouble(col.getGreen()) + " " + this.gen.formatDouble(col.getBlue()) + " setrgbcolor");
    }

    private void useColor(float red, float green, float blue) {
        if (red != this.currRed || green != this.currGreen || blue != this.currBlue) {
            this.writeln(String.valueOf(red) + " " + green + " " + blue + " setrgbcolor");
            this.currRed = red;
            this.currGreen = green;
            this.currBlue = blue;
        }
    }

    private void useColor(ColorType col) {
        this.useColor(col.getRed(), col.getGreen(), col.getBlue());
    }

    public void useFont(String name, int size) {
        if (this.currentFontName != name || this.currentFontSize != size) {
            this.writeln(String.valueOf(name) + " " + size + " F");
            this.currentFontName = name;
            this.currentFontSize = size;
        }
    }

    protected void writeln(String cmd) {
        try {
            this.gen.writeln(cmd);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }
}

