/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.ExportHook;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ExportToOoWriter
extends ExportHook {
    public void startupMapHook() {
        super.startupMapHook();
        File chosenFile = this.chooseFile("sxw", null);
        if (chosenFile == null) {
            return;
        }
        this.getController().getFrame().setWaitingCursor(true);
        try {
            this.exportToOoWriter(chosenFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getController().getFrame().setWaitingCursor(false);
    }

    private void exportToOoWriter(File file) throws IOException {
        ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(file));
        ZipEntry entry = new ZipEntry("content.xml");
        zipout.putNextEntry(entry);
        StringWriter writer = new StringWriter();
        this.getController().getMap().getXml(writer);
        StringReader reader = new StringReader(writer.getBuffer().toString());
        String xsltFileName = "accessories/mm2oowriter.xsl";
        URL xsltUrl = this.getResource(xsltFileName);
        if (xsltUrl == null) {
            this.logger.severe("Can't find " + xsltFileName + " as resource.");
            throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
        }
        InputStream xsltStream = xsltUrl.openStream();
        StreamSource xsltSource = new StreamSource(xsltStream);
        StreamResult result = new StreamResult(zipout);
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(new StreamSource(reader), result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        zipout.closeEntry();
        zipout.close();
    }
}

