/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.PermanentNodeHookAdapter;
import freemind.main.FreeMindMain;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class NodeNote
extends PermanentNodeHookAdapter {
    private NodeTextListener listener;
    private JTextArea text;
    private String myNodeText = new String();
    private JScrollPane scroller;
    private static ImageIcon noteIcon;

    public void invoke(MindMapNode node) {
        super.invoke(node);
        this.enableStateIcon(node);
    }

    private void enableStateIcon(MindMapNode node) {
        if (noteIcon == null) {
            noteIcon = new ImageIcon(this.getController().getFrame().getResource("accessories/plugins/icons/knotes.png"));
        }
        node.setStateIcon(this.getName(), noteIcon);
        this.getController().nodeRefresh(node);
    }

    public void onReceiveFocusHook() {
        super.onReceiveFocusHook();
        if (this.text == null) {
            this.logger.fine("Text ctrl. set for node " + this.getNode() + " as " + this.getMyNodeText());
            FreeMindMain frame = this.getController().getFrame();
            this.text = new JTextArea(5, 50);
            this.text.setText(this.getMyNodeText());
            this.text.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 32: {
                            e.consume();
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            });
            this.listener = new NodeTextListener();
            this.listener.setNote(this);
            this.text.getDocument().addDocumentListener(this.listener);
            this.scroller = new JScrollPane(this.text);
            this.scroller.setPreferredSize(new Dimension(600, 150));
            frame.getSouthPanel().add((Component)this.scroller, "Center");
            this.scroller.setVisible(true);
            frame.getSouthPanel().revalidate();
        }
    }

    public String getMyNodeText() {
        return new String(this.myNodeText);
    }

    public void setMyNodeText(String string) {
        this.myNodeText = new String(string);
    }

    public void onLooseFocusHook() {
        super.onLooseFocusHook();
        if (this.text != null) {
            this.listener.setNote(null);
            this.scroller.setVisible(false);
            FreeMindMain frame = this.getController().getFrame();
            frame.getSouthPanel().remove(this.scroller);
            frame.getSouthPanel().validate();
            this.scroller = null;
            this.text = null;
        }
    }

    public void loadFrom(XMLElement child) {
        XMLElement paramChild;
        super.loadFrom(child);
        if (child.getChildren().size() > 0 && (paramChild = (XMLElement)child.getChildren().get(0)) != null) {
            this.setMyNodeText(paramChild.getContent());
        }
    }

    public void save(XMLElement xml) {
        super.save(xml);
        XMLElement child = new XMLElement();
        child.setName("text");
        child.setContent(this.getMyNodeText());
        xml.addChild(child);
    }

    public void shutdownMapHook() {
        this.onLooseFocusHook();
        this.getNode().setStateIcon(this.getName(), null);
        this.getController().nodeRefresh(this.getNode());
        super.shutdownMapHook();
    }

    public class NodeTextListener
    implements DocumentListener {
        private NodeNote pNote = null;

        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void changedUpdate(DocumentEvent e) {
            try {
                if (this.pNote != null) {
                    String text = e.getDocument().getText(0, e.getDocument().getLength());
                    this.pNote.setMyNodeText(text);
                    this.pNote.nodeChanged(this.pNote.getNode());
                }
            }
            catch (BadLocationException ex) {
                System.err.println("Could not fetch nodeText content" + ex.toString());
            }
        }

        public void setNote(NodeNote note) {
            this.pNote = note;
        }
    }
}

