/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.controller.LastOpenedList;
import freemind.controller.MainToolBar;
import freemind.modes.MindMap;
import freemind.modes.Mode;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class MapModuleManager {
    private Map mapModules = new HashMap();
    private MapModule mapModule;
    private Controller c;
    private final LastOpenedList lastOpened;
    private final Controller.HistoryManager history;

    MapModuleManager(Controller c, Controller.HistoryManager history, LastOpenedList lastOpened) {
        this.c = c;
        this.history = history;
        this.lastOpened = lastOpened;
    }

    Map getMapModules() {
        return this.mapModules;
    }

    public MapModule getMapModule() {
        return this.mapModule;
    }

    public void newMapModule(MindMap map) {
        MapModule mapModule = new MapModule(map, new MapView(map, this.c), this.c.getMode());
        this.addToMapModules(mapModule.toString(), mapModule);
        this.setMapModule(mapModule);
        this.history.mapChanged(mapModule);
    }

    public void updateMapModuleName() {
        this.getMapModules().remove(this.getMapModule().toString());
        this.getMapModule().rename();
        this.addToMapModules(this.getMapModule().toString(), this.getMapModule());
        this.setMapModule(this.getMapModule());
    }

    void nextMapModule() {
        int index;
        LinkedList keys = new LinkedList(this.getMapModules().keySet());
        ListIterator i = keys.listIterator((index = keys.indexOf(this.getMapModule().toString())) + 1);
        if (i.hasNext()) {
            this.changeToMapModule((String)i.next());
        } else if (keys.iterator().hasNext()) {
            this.changeToMapModule((String)keys.iterator().next());
        }
    }

    void previousMapModule() {
        int index;
        LinkedList keys = new LinkedList(this.getMapModules().keySet());
        ListIterator i = keys.listIterator(index = keys.indexOf(this.getMapModule().toString()));
        if (i.hasPrevious()) {
            this.changeToMapModule((String)i.previous());
        } else {
            ListIterator last = keys.listIterator(keys.size() - 1);
            if (last.hasNext()) {
                this.changeToMapModule((String)last.next());
            }
        }
    }

    public boolean tryToChangeToMapModule(String mapModule) {
        if (mapModule != null && this.getMapModules().containsKey(mapModule)) {
            this.changeToMapModule(mapModule);
            return true;
        }
        return false;
    }

    void changeToMapModule(String mapModule) {
        MapModule map = (MapModule)this.getMapModules().get(mapModule);
        this.history.mapChanged(map);
        this.setMapModule(map);
    }

    public void changeToMapOfMode(Mode mode) {
        Iterator i = this.getMapModules().keySet().iterator();
        while (i.hasNext()) {
            String next = (String)i.next();
            if (((MapModule)this.getMapModules().get(next)).getMode() != mode) continue;
            this.changeToMapModule(next);
            return;
        }
    }

    void setMapModule(MapModule mapModule) {
        MapModule oldMapModule = this.mapModule;
        if (oldMapModule != null) {
            this.c.getModeController().setVisible(false);
            this.c.getModeController().shutdownController();
        }
        if (mapModule != null && mapModule.getMode() != this.c.getMode()) {
            this.c.changeToMode(((Object)mapModule.getMode()).toString());
        }
        this.mapModule = mapModule;
        LinkedList keys = new LinkedList(this.getMapModules().keySet());
        this.c.navigationPreviousMap.setEnabled(keys.size() > 1);
        this.c.navigationNextMap.setEnabled(keys.size() > 1);
        this.c.getFrame().getFreeMindMenuBar().updateMenus();
        if (mapModule != null) {
            this.c.getFrame().setView(mapModule.getView());
            this.c.setAllActions(true);
            if (this.c.getView().getSelected() == null) {
                this.c.moveToRoot();
            }
            this.lastOpened.mapOpened(this.getMapModule());
            this.c.setTitle();
            ((MainToolBar)this.c.getToolbar()).setZoomComboBox(this.getMapModule().getView().getZoom());
            this.c.obtainFocusForSelected();
            this.c.getModeController().startupController();
            this.c.getModeController().setVisible(true);
        } else {
            this.c.getFrame().setView(null);
        }
    }

    private void addToMapModules(String key, MapModule newMapModule) {
        String extension = "";
        int count = 1;
        while (this.mapModules.containsKey(key + extension)) {
            extension = "<" + ++count + ">";
        }
        newMapModule.setName(key + extension);
        this.mapModules.put(key + extension, newMapModule);
    }

    private void changeToAnotherMap(String toBeClosed) {
        LinkedList keys = new LinkedList(this.getMapModules().keySet());
        ListIterator i = keys.listIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (key.equals(toBeClosed)) continue;
            this.changeToMapModule(key);
            return;
        }
    }

    public boolean close(boolean force) {
        boolean closingNotCancelled = this.c.getMode().getModeController().close(force);
        if (!closingNotCancelled) {
            return false;
        }
        String toBeClosed = this.getMapModule().toString();
        this.mapModules.remove(toBeClosed);
        if (this.mapModules.isEmpty()) {
            this.c.setAllActions(false);
            this.setMapModule(null);
            this.c.getFrame().setView(null);
        } else {
            this.changeToMapModule((String)this.mapModules.keySet().iterator().next());
        }
        return true;
    }
}

