/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.main.Tools;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.KeyStroke;

public class NodeKeyListener
implements KeyListener {
    private Controller c;
    private String up;
    private String down;
    private String left;
    private String right;
    private boolean disabledKeyType = true;
    private boolean keyTypeAddsNew = false;

    public NodeKeyListener(Controller controller) {
        this.c = controller;
        this.up = this.c.getFrame().getProperty("keystroke_move_up");
        this.down = this.c.getFrame().getProperty("keystroke_move_down");
        this.left = this.c.getFrame().getProperty("keystroke_move_left");
        this.right = this.c.getFrame().getProperty("keystroke_move_right");
        this.disabledKeyType = Tools.safeEquals(this.c.getFrame().getProperty("disable_key_type"), "true");
        this.keyTypeAddsNew = Tools.safeEquals(this.c.getFrame().getProperty("key_type_adds_new"), "true");
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 9: 
            case 10: 
            case 16: 
            case 27: 
            case 32: 
            case 127: 
            case 155: {
                return;
            }
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.c.getView().move(e);
                return;
            }
            case 8: 
            case 35: 
            case 36: {
                this.c.getMode().getModeController().edit(e, false, false);
                return;
            }
        }
        if (!this.disabledKeyType && !e.isActionKey() && e.getKeyChar() != '\uffff') {
            this.c.getMode().getModeController().edit(e, this.keyTypeAddsNew, false);
            return;
        }
        boolean doMove = false;
        if (KeyStroke.getKeyStroke(this.up) != null && e.getKeyCode() == KeyStroke.getKeyStroke(this.up).getKeyCode()) {
            e.setKeyCode(38);
            doMove = true;
        } else if (KeyStroke.getKeyStroke(this.down) != null && e.getKeyCode() == KeyStroke.getKeyStroke(this.down).getKeyCode()) {
            e.setKeyCode(40);
            doMove = true;
        } else if (KeyStroke.getKeyStroke(this.left) != null && e.getKeyCode() == KeyStroke.getKeyStroke(this.left).getKeyCode()) {
            e.setKeyCode(37);
            doMove = true;
        } else if (KeyStroke.getKeyStroke(this.right) != null && e.getKeyCode() == KeyStroke.getKeyStroke(this.right).getKeyCode()) {
            e.setKeyCode(39);
            doMove = true;
        }
        if (doMove) {
            this.c.getView().move(e);
            e.consume();
            return;
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

