/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.actions;

import freemind.controller.Controller;
import freemind.controller.actions.ActionFilter;
import freemind.controller.actions.ActionHandler;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.XmlAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ActionFactory {
    private Controller controller;
    private Vector registeredHandler;
    private Set registeredFilters;
    private HashMap registeredActors;

    public ActionFactory(Controller c) {
        this.controller = c;
        this.registeredHandler = new Vector();
        this.registeredFilters = new HashSet();
        this.registeredActors = new HashMap();
    }

    public void registerHandler(ActionHandler newHandler) {
        if (!this.registeredHandler.contains(newHandler)) {
            this.registeredHandler.remove(newHandler);
        }
        this.registeredHandler.add(0, newHandler);
    }

    public void deregisterHandler(ActionHandler newHandler) {
        this.registeredHandler.remove(newHandler);
    }

    public void registerFilter(ActionFilter newFilter) {
        this.registeredFilters.add(newFilter);
    }

    public void deregisterFilter(ActionFilter newFilter) {
        this.registeredFilters.remove(newFilter);
    }

    public void startTransaction(String name) {
        Iterator i = this.registeredHandler.iterator();
        while (i.hasNext()) {
            ActionHandler handler = (ActionHandler)i.next();
            handler.startTransaction(name);
        }
    }

    public void endTransaction(String name) {
        Iterator i = this.registeredHandler.iterator();
        while (i.hasNext()) {
            ActionHandler handler = (ActionHandler)i.next();
            handler.endTransaction(name);
        }
    }

    public void executeAction(ActionPair pair) {
        if (pair == null) {
            return;
        }
        ActionPair filteredPair = pair;
        Iterator i = this.registeredFilters.iterator();
        while (i.hasNext()) {
            ActionFilter filter = (ActionFilter)i.next();
            filteredPair = filter.filterAction(filteredPair);
        }
        Object[] aArray = this.registeredHandler.toArray();
        for (int i2 = 0; i2 < aArray.length; ++i2) {
            ActionHandler handler = (ActionHandler)aArray[i2];
            try {
                handler.executeAction(filteredPair);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public void registerActor(ActorXml actor, Class action) {
        this.registeredActors.put(action, actor);
    }

    public ActorXml getActor(XmlAction action) {
        Iterator i = this.registeredActors.keySet().iterator();
        while (i.hasNext()) {
            Class actorClass = (Class)i.next();
            if (!actorClass.isInstance(action)) continue;
            return (ActorXml)this.registeredActors.get(actorClass);
        }
        throw new IllegalArgumentException("No actor present for xmlaction" + action.getClass());
    }
}

