/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.actions;

import freemind.controller.actions.ActorXml;
import freemind.modes.ModeController;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public abstract class FreemindAction
extends AbstractAction {
    private Icon actionIcon;
    private static Icon enabledIcon;
    private static final String ENABLED_ICON_PATH = "images/icons/button_ok.png";
    private final ModeController modeController;

    public FreemindAction(String title, Icon icon, ModeController modeController) {
        super(title, icon);
        this.actionIcon = icon;
        this.modeController = modeController;
        if (enabledIcon == null) {
            enabledIcon = new ImageIcon(modeController.getFrame().getResource(ENABLED_ICON_PATH));
        }
    }

    public FreemindAction(String title, String iconPath, ModeController modeController) {
        this(modeController.getController().getResourceString(title), iconPath == null ? null : new ImageIcon(modeController.getController().getResource(iconPath)), modeController);
    }

    protected void setSelected(JMenuItem menuItem, boolean state) {
        if (this.actionIcon == null && menuItem.getIcon() != enabledIcon) {
            this.actionIcon = menuItem.getIcon();
        }
        if (state) {
            menuItem.setIcon(enabledIcon);
        } else {
            menuItem.setIcon(this.actionIcon);
        }
    }

    public void addActor(ActorXml actor) {
        this.modeController.getActionFactory().registerActor(actor, actor.getDoActionClass());
    }

    public ModeController getModeController() {
        return this.modeController;
    }
}

