/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.controller.actions.generated.instance.Plugin;
import freemind.controller.actions.generated.instance.PluginActionType;
import freemind.controller.actions.generated.instance.PluginMenuType;
import freemind.controller.actions.generated.instance.PluginModeType;
import freemind.controller.actions.generated.instance.PluginPropertyType;
import freemind.extensions.HookInstanciationMethod;
import freemind.main.FreeMindMain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

class HookDescriptor {
    private Properties properties;
    public Vector menuPositions;
    private Vector modes;
    private PluginActionType pluginAction;
    private final Plugin pluginBase;
    private final FreeMindMain frame;

    public HookDescriptor(FreeMindMain frame, PluginActionType pluginAction, Plugin pluginBase) {
        this.frame = frame;
        this.pluginAction = pluginAction;
        this.pluginBase = pluginBase;
        if (pluginAction.getName() == null) {
            pluginAction.setName(pluginAction.getLabel());
        }
        this.menuPositions = new Vector();
        Iterator i = pluginAction.getPluginMenu().iterator();
        while (i.hasNext()) {
            PluginMenuType menu = (PluginMenuType)i.next();
            this.menuPositions.add(menu.getLocation());
        }
        this.properties = new Properties();
        i = pluginAction.getPluginProperty().iterator();
        while (i.hasNext()) {
            PluginPropertyType property = (PluginPropertyType)i.next();
            this.properties.put(property.getName(), property.getValue());
        }
        this.modes = new Vector();
        i = pluginAction.getPluginMode().iterator();
        while (i.hasNext()) {
            PluginModeType mode = (PluginModeType)i.next();
            this.modes.add(mode.getClassName());
        }
    }

    public String toString() {
        return "[HookDescriptor props=" + this.properties + ", menu positions=" + this.menuPositions + "]";
    }

    public HookInstanciationMethod getInstanciationMethod() {
        if (this.pluginAction.getInstanciation() != null) {
            HashMap allInstMethods = HookInstanciationMethod.getAllInstanciationMethods();
            Iterator i = allInstMethods.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (!this.pluginAction.getInstanciation().equalsIgnoreCase(name)) continue;
                return (HookInstanciationMethod)allInstMethods.get(name);
            }
        }
        return HookInstanciationMethod.Other;
    }

    public Vector getModes() {
        return this.modes;
    }

    public String getBaseClass() {
        return this.pluginAction.getBase();
    }

    public String getName() {
        return this.getFromResourceIfNecessary(this.pluginAction.getName());
    }

    private String getFromResourceIfNecessary(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("%")) {
            return this.frame.getController().getResourceString(string.substring(1));
        }
        return string;
    }

    public String getClassName() {
        return this.pluginAction.getClassName();
    }

    public String getDocumentation() {
        return this.getFromResourceIfNecessary(this.pluginAction.getDocumentation());
    }

    public String getIconPath() {
        return this.pluginAction.getIconPath();
    }

    public String getKeyStroke() {
        return this.pluginAction.getKeyStroke();
    }

    public Plugin getPluginBase() {
        return this.pluginBase;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

