/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapCloud;
import freemind.modes.MindMapNode;
import java.awt.Color;

public abstract class CloudAdapter
extends LineAdapter
implements MindMapCloud {
    private static Color standardColor = null;
    private static String standardStyle = null;
    private static LineAdapter.LineAdapterListener listener = null;
    private int iterativeLevel;

    public CloudAdapter(MindMapNode target, FreeMindMain frame) {
        this(target, frame, "standardcloudcolor", "standardcloudstyle");
    }

    protected CloudAdapter(MindMapNode target, FreeMindMain frame, String standardColorPropertyString, String standardStylePropertyString) {
        super(target, frame, standardColorPropertyString, standardStylePropertyString);
        this.NORMAL_WIDTH = 3;
        this.iterativeLevel = -1;
        if (listener == null) {
            listener = new LineAdapter.LineAdapterListener(this);
            Controller.addPropertyChangeListener(listener);
        }
    }

    private void calcIterativeLevel(MindMapNode target) {
        this.iterativeLevel = 0;
        if (target != null) {
            for (MindMapNode parentNode = target.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
                MindMapCloud cloud = parentNode.getCloud();
                if (cloud == null) continue;
                this.iterativeLevel = cloud.getIterativeLevel() + 1;
                break;
            }
        }
    }

    public void setTarget(MindMapNode target) {
        super.setTarget(target);
    }

    public Color getExteriorColor() {
        return this.getColor().darker();
    }

    public int getIterativeLevel() {
        if (this.iterativeLevel == -1) {
            this.calcIterativeLevel(this.target);
        }
        return this.iterativeLevel;
    }

    public void changeIterativeLevel(int deltaLevel) {
        if (this.iterativeLevel != -1) {
            this.iterativeLevel += deltaLevel;
        }
    }

    public XMLElement save() {
        XMLElement cloud = new XMLElement();
        cloud.setName("cloud");
        if (this.style != null) {
            cloud.setAttribute("STYLE", this.style);
        }
        if (this.color != null) {
            cloud.setAttribute("COLOR", Tools.colorToXml(this.color));
        }
        if (this.width != -1) {
            cloud.setAttribute("WIDTH", Integer.toString(this.width));
        }
        return cloud;
    }

    protected Color getStandardColor() {
        return standardColor;
    }

    protected void setStandardColor(Color standardColor) {
        CloudAdapter.standardColor = standardColor;
    }

    protected String getStandardStyle() {
        return standardStyle;
    }

    protected void setStandardStyle(String standardStyle) {
        CloudAdapter.standardStyle = standardStyle;
    }
}

