/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.actions.ActionFactory;
import freemind.controller.actions.ModeControllerActionHandler;
import freemind.controller.actions.UndoActionHandler;
import freemind.controller.actions.generated.instance.ObjectFactory;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookFactory;
import freemind.extensions.ModeControllerHook;
import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.extensions.UndoEventReceiver;
import freemind.main.ExampleFileFilter;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.MapAdapter;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.NodeDownAction;
import freemind.modes.StylePattern;
import freemind.modes.actions.AddArrowLinkAction;
import freemind.modes.actions.AddLocalLinkAction;
import freemind.modes.actions.ApplyPatternAction;
import freemind.modes.actions.BoldAction;
import freemind.modes.actions.ChangeArrowLinkEndPoints;
import freemind.modes.actions.ChangeArrowsInArrowLinkAction;
import freemind.modes.actions.CloudAction;
import freemind.modes.actions.CloudColorAction;
import freemind.modes.actions.ColorArrowLinkAction;
import freemind.modes.actions.CompoundActionHandler;
import freemind.modes.actions.CopyAction;
import freemind.modes.actions.CopySingleAction;
import freemind.modes.actions.CutAction;
import freemind.modes.actions.DeleteChildAction;
import freemind.modes.actions.EdgeColorAction;
import freemind.modes.actions.EdgeStyleAction;
import freemind.modes.actions.EdgeWidthAction;
import freemind.modes.actions.EditAction;
import freemind.modes.actions.FindAction;
import freemind.modes.actions.FontFamilyAction;
import freemind.modes.actions.FontSizeAction;
import freemind.modes.actions.GotoLinkNodeAction;
import freemind.modes.actions.IconAction;
import freemind.modes.actions.ImportExplorerFavoritesAction;
import freemind.modes.actions.ImportFolderStructureAction;
import freemind.modes.actions.ItalicAction;
import freemind.modes.actions.JoinNodesAction;
import freemind.modes.actions.MoveNodeAction;
import freemind.modes.actions.NewChildAction;
import freemind.modes.actions.NodeBackgroundColorAction;
import freemind.modes.actions.NodeColorAction;
import freemind.modes.actions.NodeColorBlendAction;
import freemind.modes.actions.NodeHookAction;
import freemind.modes.actions.NodeStyleAction;
import freemind.modes.actions.NodeUpAction;
import freemind.modes.actions.PasteAction;
import freemind.modes.actions.RedoAction;
import freemind.modes.actions.RemoveAllIconsAction;
import freemind.modes.actions.RemoveArrowLinkAction;
import freemind.modes.actions.RemoveLastIconAction;
import freemind.modes.actions.RevertAction;
import freemind.modes.actions.SelectAllAction;
import freemind.modes.actions.SelectBranchAction;
import freemind.modes.actions.SetLinkByTextFieldAction;
import freemind.modes.actions.ToggleChildrenFoldedAction;
import freemind.modes.actions.ToggleFoldedAction;
import freemind.modes.actions.UnderlinedAction;
import freemind.modes.actions.UndoAction;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;

public abstract class ControllerAdapter
implements ModeController {
    private static final int MINIMAL_LEAF_WIDTH = 150;
    private static final int MINIMAL_WIDTH = 50;
    private ActionFactory actionFactory;
    private HashSet nodesAlreadyUpdated;
    private HashSet nodesToBeUpdated;
    private HashSet mRegisteredMouseWheelEventHandler = new HashSet();
    private static Logger logger;
    public ApplyPatternAction[] patterns = new ApplyPatternAction[0];
    private Mode mode;
    private Clipboard clipboard;
    private int status;
    public UndoAction undo = null;
    public RedoAction redo = null;
    public CopyAction copy = null;
    public Action copySingle = null;
    public CutAction cut = null;
    public PasteAction paste = null;
    public BoldAction bold = null;
    public ItalicAction italic = null;
    public UnderlinedAction underlined = null;
    public FontSizeAction fontSize = null;
    public FontFamilyAction fontFamily = null;
    public EditAction edit = null;
    public NewChildAction newChild = null;
    public DeleteChildAction deleteChild = null;
    public ToggleFoldedAction toggleFolded = null;
    public ToggleChildrenFoldedAction toggleChildrenFolded = null;
    public NodeUpAction nodeUp = null;
    public NodeDownAction nodeDown = null;
    public EdgeColorAction edgeColor = null;
    public EdgeWidthAction EdgeWidth_WIDTH_PARENT = null;
    public EdgeWidthAction EdgeWidth_WIDTH_THIN = null;
    public EdgeWidthAction EdgeWidth_1 = null;
    public EdgeWidthAction EdgeWidth_2 = null;
    public EdgeWidthAction EdgeWidth_4 = null;
    public EdgeWidthAction EdgeWidth_8 = null;
    public EdgeWidthAction[] edgeWidths = null;
    public EdgeStyleAction EdgeStyle_linear = null;
    public EdgeStyleAction EdgeStyle_bezier = null;
    public EdgeStyleAction EdgeStyle_sharp_linear = null;
    public EdgeStyleAction EdgeStyle_sharp_bezier = null;
    public EdgeStyleAction[] edgeStyles = null;
    public NodeColorBlendAction nodeColorBlend = null;
    public NodeStyleAction fork = null;
    public NodeStyleAction bubble = null;
    public CloudAction cloud = null;
    public CloudColorAction cloudColor = null;
    public AddArrowLinkAction addArrowLinkAction = null;
    public RemoveArrowLinkAction removeArrowLinkAction = null;
    public ColorArrowLinkAction colorArrowLinkAction = null;
    public ChangeArrowsInArrowLinkAction changeArrowsInArrowLinkAction = null;
    public NodeBackgroundColorAction nodeBackgroundColor = null;
    public NodeBackgroundColorAction.RemoveNodeBackgroundColorAction removeNodeBackgroundColor = null;
    public IconAction unknwonIconAction = null;
    public RemoveLastIconAction removeLastIconAction = null;
    public RemoveAllIconsAction removeAllIconsAction = null;
    public SetLinkByTextFieldAction setLinkByTextField = null;
    public AddLocalLinkAction addLocalLinkAction = null;
    public GotoLinkNodeAction gotoLinkNodeAction = null;
    public JoinNodesAction joinNodes = null;
    public MoveNodeAction moveNodeAction = null;
    public ImportExplorerFavoritesAction importExplorerFavorites = null;
    public ImportFolderStructureAction importFolderStructure = null;
    public ChangeArrowLinkEndPoints changeArrowLinkEndPoints = null;
    public FindAction find = null;
    public FindAction.FindNextAction findNext = null;
    public NodeHookAction nodeHookAction = null;
    public RevertAction revertAction = null;
    public SelectBranchAction selectBranchAction = null;
    public SelectAllAction selectAllAction = null;
    private CompoundActionHandler compound = null;
    private Color selectionColor = new Color(200, 220, 200);
    public NodeColorAction nodeColor = null;
    private Set globalPatternList;
    private JPopupMenu popupmenu;
    protected final ControllerPopupMenuListener popupListenerSingleton = new ControllerPopupMenuListener();
    private static final int SCROLL_SKIPS = 8;
    private static final int SCROLL_SKIP = 10;
    private static final int HORIZONTAL_SCROLL_MASK = 29;
    private static final int ZOOM_MASK = 2;
    private FocusListener textFieldListener = null;
    private boolean isBlocked = false;
    public static final int NEW_CHILD_WITHOUT_FOCUS = 1;
    public static final int NEW_CHILD = 2;
    public static final int NEW_SIBLING_BEHIND = 3;
    public static final int NEW_SIBLING_BEFORE = 4;

    public ControllerAdapter(Mode mode) {
        this.setMode(mode);
        if (logger == null) {
            logger = this.getFrame().getLogger(this.getClass().getName());
        }
        this.nodesAlreadyUpdated = new HashSet();
        this.nodesToBeUpdated = new HashSet();
        this.actionFactory = new ActionFactory(this.getController());
        this.undo = new UndoAction(this);
        this.redo = new RedoAction(this);
        this.getActionFactory().registerHandler(new ModeControllerActionHandler(this.getActionFactory()));
        this.getActionFactory().registerHandler(new UndoActionHandler(this, this.undo, this.redo));
        this.cut = new CutAction(this);
        this.paste = new PasteAction(this);
        this.copy = new CopyAction(this);
        this.copySingle = new CopySingleAction(this);
        this.bold = new BoldAction(this);
        this.italic = new ItalicAction(this);
        this.underlined = new UnderlinedAction(this);
        this.fontSize = new FontSizeAction(this);
        this.fontFamily = new FontFamilyAction(this);
        this.edit = new EditAction(this);
        this.newChild = new NewChildAction(this);
        this.deleteChild = new DeleteChildAction(this);
        this.toggleFolded = new ToggleFoldedAction(this);
        this.toggleChildrenFolded = new ToggleChildrenFoldedAction(this);
        this.nodeUp = new NodeUpAction(this);
        this.nodeDown = new NodeDownAction(this);
        this.edgeColor = new EdgeColorAction(this);
        this.nodeColor = new NodeColorAction(this);
        this.nodeColorBlend = new NodeColorBlendAction(this);
        this.fork = new NodeStyleAction(this, "fork");
        this.bubble = new NodeStyleAction(this, "bubble");
        this.removeLastIconAction = new RemoveLastIconAction(this);
        this.unknwonIconAction = new IconAction(this, MindIcon.factory((String)MindIcon.getAllIconNames().get(0)), this.removeLastIconAction);
        this.removeLastIconAction.setIconAction(this.unknwonIconAction);
        this.removeAllIconsAction = new RemoveAllIconsAction(this, this.unknwonIconAction);
        try {
            File patternsFile = this.getFrame().getPatternsFile();
            if (patternsFile != null && patternsFile.exists()) {
                this.loadPatterns(patternsFile);
            } else {
                System.out.println("User patterns file " + patternsFile + " not found.");
                this.loadPatterns(new InputStreamReader(this.getResource("patterns.xml").openStream()));
            }
        }
        catch (XMLParseException e) {
            System.err.println("In patterns:" + e);
        }
        catch (Exception ex) {
            System.err.println("Patterns not loaded:" + ex);
        }
        this.EdgeWidth_WIDTH_PARENT = new EdgeWidthAction(this, -1);
        this.EdgeWidth_WIDTH_THIN = new EdgeWidthAction(this, 0);
        this.EdgeWidth_1 = new EdgeWidthAction(this, 1);
        this.EdgeWidth_2 = new EdgeWidthAction(this, 2);
        this.EdgeWidth_4 = new EdgeWidthAction(this, 4);
        this.EdgeWidth_8 = new EdgeWidthAction(this, 8);
        this.edgeWidths = new EdgeWidthAction[]{this.EdgeWidth_WIDTH_PARENT, this.EdgeWidth_WIDTH_THIN, this.EdgeWidth_1, this.EdgeWidth_2, this.EdgeWidth_4, this.EdgeWidth_8};
        this.EdgeStyle_linear = new EdgeStyleAction(this, "linear");
        this.EdgeStyle_bezier = new EdgeStyleAction(this, "bezier");
        this.EdgeStyle_sharp_linear = new EdgeStyleAction(this, "sharp_linear");
        this.EdgeStyle_sharp_bezier = new EdgeStyleAction(this, "sharp_bezier");
        this.edgeStyles = new EdgeStyleAction[]{this.EdgeStyle_linear, this.EdgeStyle_bezier, this.EdgeStyle_sharp_linear, this.EdgeStyle_sharp_bezier};
        this.cloud = new CloudAction(this);
        this.cloudColor = new CloudColorAction(this);
        this.addArrowLinkAction = new AddArrowLinkAction(this);
        this.removeArrowLinkAction = new RemoveArrowLinkAction(this, null);
        this.addArrowLinkAction.setRemoveAction(this.removeArrowLinkAction);
        this.colorArrowLinkAction = new ColorArrowLinkAction(this, null);
        this.changeArrowsInArrowLinkAction = new ChangeArrowsInArrowLinkAction(this, "none", null, null, true, true);
        this.nodeBackgroundColor = new NodeBackgroundColorAction(this);
        this.removeNodeBackgroundColor = new NodeBackgroundColorAction.RemoveNodeBackgroundColorAction(this);
        this.setLinkByTextField = new SetLinkByTextFieldAction(this);
        this.addLocalLinkAction = new AddLocalLinkAction(this);
        this.gotoLinkNodeAction = new GotoLinkNodeAction(this, null);
        this.moveNodeAction = new MoveNodeAction(this);
        this.joinNodes = new JoinNodesAction(this);
        this.importExplorerFavorites = new ImportExplorerFavoritesAction(this);
        this.importFolderStructure = new ImportFolderStructureAction(this);
        this.changeArrowLinkEndPoints = new ChangeArrowLinkEndPoints(this);
        this.find = new FindAction(this);
        this.findNext = new FindAction.FindNextAction(this, this.find);
        this.nodeHookAction = new NodeHookAction("no_title", this);
        this.revertAction = new RevertAction(this);
        this.selectBranchAction = new SelectBranchAction(this);
        this.selectAllAction = new SelectAllAction(this);
        this.compound = new CompoundActionHandler(this);
        DropTarget dropTarget = new DropTarget(this.getFrame().getViewport(), new FileOpener());
        this.clipboard = this.getFrame().getViewport().getToolkit().getSystemSelection();
        if (this.clipboard == null) {
            this.clipboard = this.getFrame().getViewport().getToolkit().getSystemClipboard();
        }
    }

    private void loadPatterns(File file) throws Exception {
        this.createPatterns(StylePattern.loadPatterns(file));
    }

    private void loadPatterns(Reader reader) throws Exception {
        this.createPatterns(StylePattern.loadPatterns(reader));
    }

    private void createPatterns(List patternsList) throws Exception {
        this.globalPatternList = new HashSet();
        this.globalPatternList.addAll(patternsList);
        this.patterns = new ApplyPatternAction[patternsList.size()];
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = new ApplyPatternAction(this, (StylePattern)patternsList.get(i));
            MindIcon patternIcon = ((StylePattern)patternsList.get(i)).getNodeIcon();
            if (patternIcon == null) continue;
            this.patterns[i].putValue("SmallIcon", patternIcon.getIcon(this.getFrame()));
        }
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public abstract MindMapNode newNode(Object var1);

    protected MindMapNode newNode() {
        return this.newNode(null);
    }

    public MapAdapter newModel() {
        throw new UnsupportedOperationException();
    }

    protected FileFilter getFileFilter() {
        return null;
    }

    public void nodeChanged(MindMapNode node) {
        this.getMap().setSaved(false);
        this.nodeRefresh(node, true);
    }

    public void nodeRefresh(MindMapNode node) {
        this.nodeRefresh(node, false);
    }

    private void nodeRefresh(MindMapNode node, boolean isUpdate) {
        logger.finest("nodeChanged called for node " + node + " parent=" + node.getParentNode());
        if (this.nodesAlreadyUpdated.contains(node)) {
            return;
        }
        this.nodesToBeUpdated.add(node);
        this.nodesAlreadyUpdated.add(node);
        if (isUpdate) {
            if (node.getHistoryInformation() != null) {
                node.getHistoryInformation().setLastModifiedAt(new Date());
            }
            this.recursiveCallUpdateHooks(node, node);
        }
        this.getMap().nodeChangedMapInternal(node);
        this.nodesToBeUpdated.remove(node);
        if (this.nodesToBeUpdated.size() == 0) {
            this.nodesAlreadyUpdated.clear();
        }
    }

    public void nodeStructureChanged(MindMapNode node) {
        this.getMap().nodeStructureChanged(node);
    }

    public boolean isUndoAction() {
        return this.undo.isUndoAction() || this.redo.isUndoAction();
    }

    private void recursiveCallUpdateHooks(MindMapNode node, MindMapNode changedNode) {
        if (node instanceof MindMapNode) {
            Iterator i = node.getActivatedHooks().iterator();
            while (i.hasNext()) {
                PermanentNodeHook hook = (PermanentNodeHook)i.next();
                if (this.isUndoAction() && !(hook instanceof UndoEventReceiver)) continue;
                if (node == changedNode) {
                    hook.onUpdateNodeHook();
                    continue;
                }
                hook.onUpdateChildrenHook(changedNode);
            }
        }
        if (!node.isRoot() && node.getParentNode() != null) {
            this.recursiveCallUpdateHooks(node.getParentNode(), changedNode);
        }
    }

    public void anotherNodeSelected(MindMapNode n) {
    }

    public void doubleClick(MouseEvent e) {
        if (this.getSelecteds().size() != 1) {
            return;
        }
        MindMapNode node = ((NodeView)e.getComponent()).getModel();
        if (node.hasChildren()) {
            this.plainClick(e);
            return;
        }
        if (!(e.isAltDown() || e.isControlDown() || e.isShiftDown() || e.isPopupTrigger() || e.getButton() != 1 || node.getLink() != null)) {
            this.edit(null, false, false);
        }
    }

    public void plainClick(MouseEvent e) {
        if (this.getSelecteds().size() != 1) {
            return;
        }
        MindMapNode node = ((NodeView)e.getComponent()).getModel();
        if (this.getView().getSelected().isInFollowLinkRegion(e.getX())) {
            this.loadURL();
        } else {
            if (!node.hasChildren()) {
                this.doubleClick(e);
                return;
            }
            this.toggleFolded();
        }
    }

    public String getText(String textId) {
        return this.getController().getResourceString(textId);
    }

    protected boolean binOptionIsTrue(String option) {
        return this.getFrame().getProperty(option).equals("true");
    }

    public MindMap newMap() {
        MapAdapter newModel = this.newModel();
        this.newMap(newModel);
        return newModel;
    }

    public void newMap(MindMap mapModel) {
        this.getController().getMapModuleManager().newMapModule(mapModel);
    }

    public void load(File file) throws FileNotFoundException, IOException, XMLParseException {
        MapAdapter model = this.newModel();
        model.load(file);
        this.getController().getMapModuleManager().newMapModule(model);
        this.getController().getModeController().invokeHooksRecursively((NodeAdapter)this.getModel().getRoot(), this.getModel());
    }

    public boolean save() {
        if (this.getModel().isSaved()) {
            return true;
        }
        if (this.getModel().getFile() == null || this.getModel().isReadOnly()) {
            return this.saveAs();
        }
        return this.save(this.getModel().getFile());
    }

    public void load(String xmlMapContents) {
        this.revertAction.openXmlInsteadOfMap(xmlMapContents);
    }

    public List getSelecteds() {
        LinkedList<MindMapNode> selecteds = new LinkedList<MindMapNode>();
        ListIterator it = this.getView().getSelecteds().listIterator();
        if (it != null) {
            while (it.hasNext()) {
                NodeView selected = (NodeView)it.next();
                selecteds.add(selected.getModel());
            }
        }
        return selecteds;
    }

    public List getSelectedsByDepth() {
        List result = this.getSelecteds();
        this.sortNodesByDepth(result);
        return result;
    }

    public void sortNodesByDepth(List inPlaceList) {
        Collections.sort(inPlaceList, new nodesDepthComparator());
        logger.finest("Sort result: " + inPlaceList);
    }

    public boolean save(File file) {
        return this.getModel().save(file);
    }

    protected JMenuItem add(JMenu menu, Action action, String keystroke) {
        JMenuItem item = menu.add(action);
        item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getProperty(keystroke)));
        return item;
    }

    protected JMenuItem add(StructuredMenuHolder holder, String category, Action action, String keystroke) {
        JMenuItem item = holder.addMenuItem(new JMenuItem(action), category);
        if (keystroke != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getProperty(keystroke)));
        }
        return item;
    }

    protected JMenuItem addCheckBox(StructuredMenuHolder holder, String category, Action action, String keystroke) {
        JCheckBoxMenuItem item = (JCheckBoxMenuItem)holder.addMenuItem(new JCheckBoxMenuItem(action), category);
        if (keystroke != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getProperty(keystroke)));
        }
        return item;
    }

    protected void add(JMenu menu, Action action) {
        menu.add(action);
    }

    public void open() {
        int returnVal;
        JFileChooser chooser = null;
        chooser = this.getMap() != null && this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null ? new JFileChooser(this.getMap().getFile().getParentFile()) : new JFileChooser();
        if (this.getFileFilter() != null) {
            chooser.addChoosableFileFilter(this.getFileFilter());
        }
        if ((returnVal = chooser.showOpenDialog(this.getView())) == 0) {
            try {
                this.load(chooser.getSelectedFile());
            }
            catch (Exception ex) {
                this.handleLoadingException(ex);
            }
        }
        this.getController().setTitle();
    }

    public void handleLoadingException(Exception ex) {
        String exceptionType = ex.getClass().getName();
        if (exceptionType.equals("freemind.main.XMLParseException")) {
            int showDetail = JOptionPane.showConfirmDialog(this.getView(), this.getText("map_corrupted"), "FreeMind", 0, 0);
            if (showDetail == 0) {
                this.getController().errorMessage(ex);
            }
        } else if (exceptionType.equals("java.io.FileNotFoundException")) {
            this.getController().errorMessage(ex.getMessage());
        } else {
            ex.printStackTrace();
            this.getController().errorMessage(ex);
        }
    }

    public boolean saveAs() {
        int overwriteMap;
        JFileChooser chooser = null;
        if (this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null) {
            chooser = new JFileChooser(this.getMap().getFile().getParentFile());
        } else {
            chooser = new JFileChooser();
            chooser.setSelectedFile(new File(this.getFileNameProposal() + ".mm"));
        }
        if (this.getFileFilter() != null) {
            chooser.addChoosableFileFilter(this.getFileFilter());
        }
        chooser.setDialogTitle(this.getText("save_as"));
        int returnVal = chooser.showSaveDialog(this.getView());
        if (returnVal != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        String ext = Tools.getExtension(f.getName());
        if (!ext.equals("mm")) {
            f = new File(f.getParent(), f.getName() + ".mm");
        }
        if (f.exists() && (overwriteMap = JOptionPane.showConfirmDialog(this.getView(), this.getText("map_already_exists"), "FreeMind", 0)) != 0) {
            return false;
        }
        try {
            String lockingUser = this.getModel().tryToLock(f);
            if (lockingUser != null) {
                this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("map_locked_by_save_as"), f.getName(), lockingUser));
                return false;
            }
        }
        catch (Exception e) {
            this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("locking_failed_by_save_as"), f.getName()));
            return false;
        }
        this.save(f);
        this.getController().getMapModuleManager().updateMapModuleName();
        return true;
    }

    private String getFileNameProposal() {
        String rootText = ((Object)((MindMapNode)this.getMap().getRoot())).toString();
        rootText = rootText.replaceAll("[&:/\\\\\u0000%$#~\\?\\*]+", "");
        return rootText;
    }

    public boolean close(boolean force) {
        Object[] options = new String[]{this.getText("yes"), this.getText("no"), this.getText("cancel")};
        if (!force && !this.getModel().isSaved()) {
            boolean savingNotCancelled;
            String text = this.getText("save_unsaved") + "\n" + this.getMapModule().toString();
            String title = this.getText("save");
            int returnVal = JOptionPane.showOptionDialog(this.getFrame().getContentPane(), text, title, 1, 3, null, options, options[0]);
            if (returnVal == 0 ? !(savingNotCancelled = this.save()) : returnVal == 2 || returnVal == -1) {
                return false;
            }
        }
        this.getModel().destroy();
        return true;
    }

    public void setVisible(boolean visible) {
        block3: {
            block2: {
                if (!visible) break block2;
                MindMapNode node = this.getSelected();
                Iterator j = node.getActivatedHooks().iterator();
                while (j.hasNext()) {
                    PermanentNodeHook hook = (PermanentNodeHook)j.next();
                    hook.onReceiveFocusHook();
                }
                break block3;
            }
            MindMapNode node = this.getSelected();
            if (node == null) break block3;
            Iterator j = node.getActivatedHooks().iterator();
            while (j.hasNext()) {
                PermanentNodeHook hook = (PermanentNodeHook)j.next();
                hook.onLooseFocusHook();
            }
        }
    }

    protected void setAllActions(boolean enabled) {
        int i;
        this.getController().zoomIn.setEnabled(enabled);
        this.getController().zoomOut.setEnabled(enabled);
        this.cut.setEnabled(enabled);
        this.copy.setEnabled(enabled);
        this.copySingle.setEnabled(enabled);
        this.paste.setEnabled(enabled);
        this.undo.setEnabled(enabled);
        this.redo.setEnabled(enabled);
        this.edit.setEnabled(enabled);
        this.newChild.setEnabled(enabled);
        this.toggleFolded.setEnabled(enabled);
        this.toggleChildrenFolded.setEnabled(enabled);
        this.setLinkByTextField.setEnabled(enabled);
        this.italic.setEnabled(enabled);
        this.bold.setEnabled(enabled);
        this.find.setEnabled(enabled);
        this.findNext.setEnabled(enabled);
        this.addArrowLinkAction.setEnabled(enabled);
        this.addLocalLinkAction.setEnabled(enabled);
        this.nodeColorBlend.setEnabled(enabled);
        this.nodeUp.setEnabled(enabled);
        this.nodeBackgroundColor.setEnabled(enabled);
        this.nodeDown.setEnabled(enabled);
        this.importExplorerFavorites.setEnabled(enabled);
        this.importFolderStructure.setEnabled(enabled);
        this.joinNodes.setEnabled(enabled);
        this.deleteChild.setEnabled(enabled);
        this.cloud.setEnabled(enabled);
        this.cloudColor.setEnabled(enabled);
        this.nodeColor.setEnabled(enabled);
        this.edgeColor.setEnabled(enabled);
        this.removeLastIconAction.setEnabled(enabled);
        this.removeAllIconsAction.setEnabled(enabled);
        this.selectAllAction.setEnabled(enabled);
        this.selectBranchAction.setEnabled(enabled);
        this.removeNodeBackgroundColor.setEnabled(enabled);
        this.moveNodeAction.setEnabled(enabled);
        this.revertAction.setEnabled(enabled);
        for (i = 0; i < this.edgeWidths.length; ++i) {
            this.edgeWidths[i].setEnabled(enabled);
        }
        this.fork.setEnabled(enabled);
        this.bubble.setEnabled(enabled);
        for (i = 0; i < this.edgeStyles.length; ++i) {
            this.edgeStyles[i].setEnabled(enabled);
        }
        for (i = 0; i < this.patterns.length; ++i) {
            this.patterns[i].setEnabled(enabled);
        }
    }

    public void showPopupMenu(MouseEvent e) {
        JPopupMenu popupmenu;
        if (e.isPopupTrigger() && (popupmenu = this.getPopupMenu()) != null) {
            popupmenu.addPopupMenuListener(this.popupListenerSingleton);
            popupmenu.show(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    public JPopupMenu getPopupForModel(Object obj) {
        return null;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.isBlocked()) {
            return;
        }
        Iterator i = this.mRegisteredMouseWheelEventHandler.iterator();
        while (i.hasNext()) {
            ModeController.MouseWheelEventHandler handler = (ModeController.MouseWheelEventHandler)i.next();
            boolean result = handler.handleMouseWheelEvent(e);
            if (!result) continue;
            return;
        }
        if ((e.getModifiers() & 2) != 0) {
            float newZoomFactor = 1.0f + Math.abs((float)e.getWheelRotation()) / 10.0f;
            if (e.getWheelRotation() < 0) {
                newZoomFactor = 1.0f / newZoomFactor;
            }
            float newZoom = ((MapView)e.getComponent()).getZoom() * newZoomFactor;
            newZoom = (float)Math.rint(newZoom * 1000.0f) / 1000.0f;
            this.getController().setZoom(newZoom);
        } else if ((e.getModifiers() & 0x1D) != 0) {
            for (int i2 = 0; i2 < 8; ++i2) {
                ((MapView)e.getComponent()).scrollBy(10 * e.getWheelRotation(), 0, false);
            }
        } else {
            for (int i3 = 0; i3 < 8; ++i3) {
                ((MapView)e.getComponent()).scrollBy(0, 10 * e.getWheelRotation(), false);
            }
        }
    }

    public void registerMouseWheelEventHandler(ModeController.MouseWheelEventHandler handler) {
        logger.info("Registered   MouseWheelEventHandler " + handler);
        this.mRegisteredMouseWheelEventHandler.add(handler);
    }

    public void deRegisterMouseWheelEventHandler(ModeController.MouseWheelEventHandler handler) {
        logger.info("Deregistered MouseWheelEventHandler " + handler);
        this.mRegisteredMouseWheelEventHandler.remove(handler);
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    public void setBold(MindMapNode node, boolean bolded) {
        this.bold.setBold(node, bolded);
    }

    public void setItalic(MindMapNode node, boolean isItalic) {
        this.italic.setItalic(node, isItalic);
    }

    public void setCloud(MindMapNode node, boolean enable) {
        this.cloud.setCloud(node, enable);
    }

    public void setCloudColor(MindMapNode node, Color color) {
        this.cloudColor.setCloudColor(node, color);
    }

    public void setFontSize(MindMapNode node, String fontSizeValue) {
        this.fontSize.setFontSize(node, fontSizeValue);
    }

    public void increaseFontSize(MindMapNode node, int increment) {
        int newSize = Integer.valueOf(node.getFontSize()) + increment;
        if (newSize > 0) {
            this.setFontSize(node, Integer.toString(newSize));
        }
    }

    public void setFontFamily(MindMapNode node, String fontFamilyValue) {
        this.fontFamily.setFontFamily(node, fontFamilyValue);
    }

    public void setNodeColor(MindMapNode node, Color color) {
        this.nodeColor.setNodeColor(node, color);
    }

    public void setNodeBackgroundColor(MindMapNode node, Color color) {
        this.nodeBackgroundColor.setNodeBackgroundColor(node, color);
    }

    public void blendNodeColor(MindMapNode node) {
        Color mapColor = this.getMap().getBackgroundColor();
        Color nodeColor = node.getColor();
        if (nodeColor == null) {
            nodeColor = Tools.xmlToColor(this.getFrame().getProperty("standardnodecolor"));
        }
        this.setNodeColor(node, new Color((3 * mapColor.getRed() + nodeColor.getRed()) / 4, (3 * mapColor.getGreen() + nodeColor.getGreen()) / 4, (3 * mapColor.getBlue() + nodeColor.getBlue()) / 4));
    }

    public void setEdgeColor(MindMapNode node, Color color) {
        this.edgeColor.setEdgeColor(node, color);
    }

    public void applyPattern(MindMapNode node, String patternName) {
        for (int i = 0; i < this.patterns.length; ++i) {
            ApplyPatternAction patternAction = this.patterns[i];
            if (!patternAction.getPattern().getName().equals(patternName)) continue;
            patternAction.applyPattern(node, patternAction.getPattern());
            break;
        }
    }

    public void applyPattern(MindMapNode node, StylePattern pattern) {
        if (this.patterns.length <= 0) {
            throw new IllegalArgumentException("No pattern defined.");
        }
        this.patterns[0].applyPattern(node, pattern);
    }

    public void addIcon(MindMapNode node, MindIcon icon) {
        this.unknwonIconAction.addIcon(node, icon);
    }

    public void removeAllIcons(MindMapNode node) {
        this.removeAllIconsAction.removeAllIcons(node);
    }

    public int removeLastIcon(MindMapNode node) {
        return this.removeLastIconAction.removeLastIcon(node);
    }

    public void addLink(MindMapNode source, MindMapNode target) {
        this.addArrowLinkAction.addLink(source, target);
    }

    public void removeReference(MindMapLink arrowLink) {
        this.removeArrowLinkAction.removeReference(arrowLink);
    }

    public void setArrowLinkColor(MindMapLink arrowLink, Color color) {
        this.colorArrowLinkAction.setArrowLinkColor(arrowLink, color);
    }

    public void changeArrowsOfArrowLink(MindMapArrowLinkModel arrowLink, boolean hasStartArrow, boolean hasEndArrow) {
        this.changeArrowsInArrowLinkAction.changeArrowsOfArrowLink(arrowLink, hasStartArrow, hasEndArrow);
    }

    public void setArrowLinkEndPoints(MindMapArrowLink link, Point startPoint, Point endPoint) {
        this.changeArrowLinkEndPoints.setArrowLinkEndPoints(link, startPoint, endPoint);
    }

    public void setLink(MindMapNode node, String link) {
        this.setLinkByTextField.setLink(node, link);
    }

    public void setToolTip(MindMapNode node, String key, String value) {
        node.setToolTip(key, value);
        this.nodeRefresh(node);
    }

    public void edit(KeyEvent e, boolean addNew, boolean editLong) {
        this.edit.edit(e, addNew, editLong);
    }

    public void setNodeText(MindMapNode selected, String newText) {
        this.edit.setNodeText(selected, newText);
    }

    public void setEdgeWidth(MindMapNode node, int width) {
        this.EdgeWidth_1.setEdgeWidth(node, width);
    }

    public void setEdgeStyle(MindMapNode node, String style) {
        this.EdgeStyle_bezier.setEdgeStyle(node, style);
    }

    public void setNodeStyle(MindMapNode node, String style) {
        this.fork.setStyle(node, style);
    }

    public Transferable cut() {
        return this.cut(this.getSelecteds());
    }

    public Transferable cut(List nodeList) {
        return this.cut.cut(nodeList);
    }

    public void paste(Transferable t, MindMapNode parent) {
        boolean isLeft = false;
        if (parent.isLeft() != null) {
            isLeft = parent.isLeft().getValue();
        }
        this.paste(t, parent, false, isLeft);
    }

    public void paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        this.paste.paste(t, target, asSibling, isLeft);
    }

    public void paste(MindMapNode node, MindMapNode parent) {
        this.paste.paste(node, parent);
    }

    public MindMapNode addNew(MindMapNode target, int newNodeMode, KeyEvent e) {
        return this.newChild.addNew(target, newNodeMode, e);
    }

    public MindMapNode addNewNode(MindMapNode parent, int index, Tools.BooleanHolder newNodeIsLeft) {
        return this.newChild.addNewNode(parent, index, newNodeIsLeft);
    }

    public void deleteNode(MindMapNode selectedNode) {
        this.deleteChild.deleteNode(selectedNode);
    }

    public void toggleFolded() {
        this.toggleFolded.toggleFolded();
    }

    public void setFolded(MindMapNode node, boolean folded) {
        this.toggleFolded.setFolded(node, folded);
    }

    public void displayNode(MindMapNode node) {
        this.find.displayNode(node, null);
    }

    public void centerNode(MindMapNode node) {
        if (node.getViewer() == null) {
            this.displayNode(node);
        }
        this.getView().centerNode(node.getViewer());
        this.getView().selectAsTheOnlyOneSelected(node.getViewer());
        this.getController().obtainFocusForSelected();
    }

    public String getLinkShortText(MindMapNode node) {
        return this.gotoLinkNodeAction.getShortTextForLink(node);
    }

    public void moveNodes(MindMapNode selected, List selecteds, int direction) {
        this.nodeUp.moveNodes(selected, selecteds, direction);
    }

    public void joinNodes(MindMapNode selectedNode, List selectedNodes) {
        this.joinNodes.joinNodes(selectedNode, selectedNodes);
    }

    protected void setLinkByFileChooser() {
        String relative = this.getLinkByFileChooser(this.getFileFilter());
        if (relative != null) {
            this.setLink((NodeAdapter)this.getSelected(), relative);
        }
    }

    protected void setImageByFileChooser() {
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("jpeg");
        filter.addExtension("png");
        filter.addExtension("gif");
        filter.setDescription("JPG, PNG and GIF Images");
        boolean picturesAmongSelecteds = false;
        ListIterator e = this.getSelecteds().listIterator();
        while (e.hasNext()) {
            String link = ((MindMapNode)e.next()).getLink();
            if (link == null || !filter.accept(new File(link))) continue;
            picturesAmongSelecteds = true;
            break;
        }
        try {
            if (picturesAmongSelecteds) {
                e = this.getSelecteds().listIterator();
                while (e.hasNext()) {
                    String possiblyRelative;
                    String relative;
                    MindMapNode node = (MindMapNode)e.next();
                    if (node.getLink() == null || (relative = Tools.isAbsolutePath(possiblyRelative = node.getLink()) ? new File(possiblyRelative).toURL().toString() : possiblyRelative) == null) continue;
                    String strText = "<html><img src=\"" + relative + "\">";
                    this.setLink(node, null);
                    this.setNodeText(node, strText);
                }
            } else {
                String relative = this.getLinkByFileChooser(filter);
                if (relative != null) {
                    String strText = "<html><img src=\"" + relative + "\">";
                    this.setNodeText(this.getSelected(), strText);
                }
            }
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
        }
    }

    protected String getLinkByFileChooser(FileFilter fileFilter) {
        String relative = null;
        JFileChooser chooser = null;
        if (this.getMap().getFile() == null) {
            JOptionPane.showMessageDialog(this.getFrame().getContentPane(), this.getText("not_saved_for_link_error"), "FreeMind", 2);
            return null;
        }
        chooser = this.getMap().getFile() != null && this.getMap().getFile().getParentFile() != null ? new JFileChooser(this.getMap().getFile().getParentFile()) : new JFileChooser();
        if (fileFilter != null) {
            chooser.setFileFilter(fileFilter);
        } else {
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        }
        int returnVal = chooser.showOpenDialog(this.getFrame().getContentPane());
        if (returnVal == 0) {
            URL link;
            File input = chooser.getSelectedFile();
            try {
                link = input.toURL();
                relative = link.toString();
            }
            catch (MalformedURLException ex) {
                this.getController().errorMessage(this.getText("url_error"));
                return null;
            }
            if (this.getFrame().getProperty("links").equals("relative")) {
                try {
                    relative = Tools.toRelativeURL(this.getMap().getFile().toURL(), link);
                }
                catch (MalformedURLException ex) {
                    this.getController().errorMessage(this.getText("url_error"));
                    return null;
                }
            }
        }
        return relative;
    }

    public void loadURL(String relative) {
        URL absolute = null;
        if (this.getMap().getFile() == null) {
            this.getFrame().out("You must save the current map first!");
            this.save();
        }
        try {
            if (Tools.isAbsolutePath(relative)) {
                absolute = new File(relative).toURL();
            } else {
                if (relative.startsWith("#")) {
                    logger.finest("found relative link to " + relative);
                    String target = relative.substring(1);
                    try {
                        NodeAdapter node = this.getNodeFromID(target);
                        this.centerNode(node);
                        return;
                    }
                    catch (Exception e) {
                        throw new FileNotFoundException(null);
                    }
                }
                absolute = new URL(this.getMap().getFile().toURL(), relative);
            }
            String extension = Tools.getExtension(absolute.toString());
            if (extension != null && extension.equals("mm")) {
                String fileName = absolute.getFile();
                File file = new File(fileName);
                if (!this.getController().getMapModuleManager().tryToChangeToMapModule(file.getName())) {
                    this.getFrame().setWaitingCursor(true);
                    this.load(file);
                }
            } else {
                this.getFrame().openDocument(absolute);
            }
        }
        catch (MalformedURLException ex) {
            this.getController().errorMessage(this.getText("url_error") + "\n" + ex);
            return;
        }
        catch (FileNotFoundException e) {
            int returnVal = JOptionPane.showConfirmDialog(this.getView(), this.getText("repair_link_question"), this.getText("repair_link"), 0);
            if (returnVal == 0) {
                this.setLinkByTextField.actionPerformed(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getFrame().setWaitingCursor(false);
    }

    public void loadURL() {
        String link = this.getSelected().getLink();
        if (link != null) {
            this.loadURL(link);
        }
    }

    protected Mode getMode() {
        return this.mode;
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
    }

    protected MapModule getMapModule() {
        return this.getController().getMapModuleManager().getMapModule();
    }

    public MapAdapter getMap() {
        if (this.getMapModule() != null) {
            return (MapAdapter)this.getMapModule().getModel();
        }
        return null;
    }

    public MindMapNode getRootNode() {
        return (MindMapNode)this.getMap().getRoot();
    }

    public URL getResource(String name) {
        return this.getFrame().getResource(name);
    }

    public Controller getController() {
        return this.getMode().getController();
    }

    public FreeMindMain getFrame() {
        return this.getController().getFrame();
    }

    public ControllerAdapter getModeController() {
        return this;
    }

    public MapAdapter getModel() {
        return (MapAdapter)this.getController().getModel();
    }

    public MapView getView() {
        return this.getController().getView();
    }

    protected void updateMapModuleName() {
        this.getController().getMapModuleManager().updateMapModuleName();
    }

    public NodeAdapter getNodeFromID(String nodeID) {
        NodeAdapter node = (NodeAdapter)this.getMap().getLinkRegistry().getTargetForID(nodeID);
        if (node == null) {
            throw new IllegalArgumentException("Node belonging to the node id " + nodeID + " not found.");
        }
        return node;
    }

    public String getNodeID(MindMapNode selected) {
        this.getMap().getLinkRegistry().registerLinkTarget(selected);
        return this.getMap().getLinkRegistry().getLabel(selected);
    }

    public MindMapNode getSelected() {
        if (this.getView() != null && this.getView().getSelected() != null) {
            return this.getView().getSelected().getModel();
        }
        return null;
    }

    public boolean extendSelection(MouseEvent e) {
        NodeView newlySelectedNodeView = (NodeView)e.getSource();
        boolean extend = e.isControlDown();
        boolean range = e.isShiftDown();
        boolean branch = e.isAltGraphDown() || e.isAltDown();
        boolean retValue = false;
        if (extend || range || branch || !this.getView().isSelected(newlySelectedNodeView)) {
            if (!range) {
                if (extend) {
                    this.getView().toggleSelected(newlySelectedNodeView);
                } else {
                    this.select(newlySelectedNodeView);
                }
                retValue = true;
            } else {
                retValue = this.getView().selectContinuous(newlySelectedNodeView);
            }
            if (branch) {
                this.getView().selectBranch(newlySelectedNodeView, extend);
                retValue = true;
            }
        }
        if (retValue) {
            e.consume();
            String link = newlySelectedNodeView.getModel().getLink();
            link = link != null ? link : " ";
            this.getController().getFrame().out(link);
        }
        return retValue;
    }

    public void select(NodeView node) {
        this.getView().scrollNodeToVisible(node);
        this.getView().selectAsTheOnlyOneSelected(node);
        this.getView().setSiblingMaxLevel(node.getModel().getNodeLevel());
    }

    public void select(MindMapNode selected) {
        this.displayNode(selected);
        this.select(selected.getViewer());
    }

    public void selectMultipleNodes(MindMapNode focussed, Collection selecteds) {
        MindMapNode node;
        Iterator i = selecteds.iterator();
        while (i.hasNext()) {
            node = (MindMapNode)i.next();
            this.displayNode(node);
        }
        this.select(focussed);
        i = selecteds.iterator();
        while (i.hasNext()) {
            node = (MindMapNode)i.next();
            this.getView().makeTheSelected(node.getViewer());
        }
        this.getController().obtainFocusForSelected();
    }

    public void selectBranch(MindMapNode selected, boolean extend) {
        this.displayNode(selected);
        this.getView().selectBranch(selected.getViewer(), extend);
    }

    public void invokeHook(ModeControllerHook hook) {
        hook.setController(this);
        hook.startupMapHook();
        hook.shutdownMapHook();
    }

    public void invokeHooksRecursively(NodeAdapter node, MindMap map) {
        Iterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            NodeAdapter child = (NodeAdapter)i.next();
            this.invokeHooksRecursively(child, map);
        }
        i = node.getHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook hook = (PermanentNodeHook)i.next();
            hook.setController(this);
            hook.setMap(map);
            node.invokeHook(hook);
        }
    }

    public NodeHook createNodeHook(String hookName, MindMapNode node, MindMap map) {
        HookFactory hookFactory = this.getFrame().getHookFactory();
        NodeHook hook = hookFactory.createNodeHook(hookName);
        hook.setController(this);
        hook.setMap(map);
        if (hook instanceof PermanentNodeHook) {
            PermanentNodeHook otherHook;
            PermanentNodeHook permHook = (PermanentNodeHook)hook;
            if (hookFactory.getInstanciationMethod(hookName).isSingleton() && (otherHook = hookFactory.getHookInNode(node, hookName)) != null) {
                return otherHook;
            }
            node.addHook(permHook);
        }
        return hook;
    }

    public void addHook(MindMapNode focussed, List selecteds, String hookName) {
        this.nodeHookAction.addHook(focussed, selecteds, hookName);
    }

    public String marshall(XmlAction action) {
        return this.getController().marshall(action);
    }

    public XmlAction unMarshall(String inputString) {
        return this.getController().unMarshall(inputString);
    }

    public ObjectFactory getActionXmlFactory() {
        return this.getController().getActionXmlFactory();
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public void updatePopupMenu(StructuredMenuHolder holder) {
    }

    public void shutdownController() {
        this.setAllActions(false);
    }

    public void startupController() {
        this.setAllActions(true);
        if (this.getFrame().getView() != null) {
            DropTarget dropTarget = new DropTarget(this.getFrame().getView(), new FileOpener());
        }
    }

    public void splitNode(MindMapNode node, int caretPosition, String newText) {
        String futureText = newText != null ? newText : ((Object)node).toString();
        String newLowerContent = futureText.substring(caretPosition, futureText.length());
        String newUpperContent = futureText.substring(0, caretPosition);
        this.setNodeText(node, newLowerContent);
        MindMapNode parent = node.getParentNode();
        MindMapNode upperNode = this.addNewNode(parent, parent.getChildPosition(node), parent.isLeft());
        upperNode.setColor(node.getColor());
        upperNode.setFont(node.getFont());
        this.setNodeText(upperNode, newUpperContent);
    }

    public void moveNodePosition(MindMapNode node, int vGap, int hGap, int shiftY) {
        this.moveNodeAction.moveNodeTo(node, vGap, hGap, shiftY);
    }

    protected class FileOpener
    implements DropTargetListener {
        protected FileOpener() {
        }

        private boolean isDragAcceptable(DropTargetDragEvent event) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        private boolean isDropAcceptable(DropTargetDropEvent event) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return false;
        }

        public void drop(DropTargetDropEvent dtde) {
            if (!this.isDropAcceptable(dtde)) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(1);
            try {
                Object data = dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (data == null) {
                    dtde.dropComplete(false);
                    return;
                }
                Iterator iterator = ((List)data).iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    ControllerAdapter.this.load(file);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(ControllerAdapter.this.getView(), "Couldn't open dropped file(s). Reason: " + e.getMessage());
                dtde.dropComplete(false);
                return;
            }
            dtde.dropComplete(true);
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.isDragAcceptable(dtde)) {
                dtde.rejectDrag();
                return;
            }
        }

        public void dragOver(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dragScroll(DropTargetDragEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    protected class FollowLinkAction
    extends AbstractAction {
        public FollowLinkAction() {
            super(ControllerAdapter.this.getText("follow_link"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.loadURL();
        }
    }

    protected class SetImageByFileChooserAction
    extends AbstractAction {
        public SetImageByFileChooserAction() {
            super(ControllerAdapter.this.getText("set_image_by_filechooser"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.setImageByFileChooser();
            ControllerAdapter.this.getController().obtainFocusForSelected();
        }
    }

    protected class SetLinkByFileChooserAction
    extends AbstractAction {
        public SetLinkByFileChooserAction() {
            super(ControllerAdapter.this.getText("set_link_by_filechooser"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.setLinkByFileChooser();
        }
    }

    protected class EditLongAction
    extends AbstractAction {
        public EditLongAction() {
            super(ControllerAdapter.this.getText("edit_long_node"));
        }

        public void actionPerformed(ActionEvent e) {
            ControllerAdapter.this.edit(null, false, true);
        }
    }

    protected class ModeControllerHookAction
    extends AbstractAction {
        String hookName;
        ModeController controller;

        public ModeControllerHookAction(String hookName, ModeController controller) {
            super(hookName);
            this.hookName = hookName;
            this.controller = controller;
        }

        public void actionPerformed(ActionEvent arg0) {
            HookFactory hookFactory = ControllerAdapter.this.getFrame().getHookFactory();
            ModeControllerHook hook = hookFactory.createModeControllerHook(this.hookName);
            hook.setController(this.controller);
            ControllerAdapter.this.invokeHook(hook);
        }
    }

    protected class SaveAsAction
    extends AbstractAction {
        ControllerAdapter mc;

        public SaveAsAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("save_as"), new ImageIcon(ControllerAdapter.this.getResource("images/filesaveas.png")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            this.mc.saveAs();
            ControllerAdapter.this.getController().setTitle();
        }
    }

    protected class SaveAction
    extends AbstractAction {
        ControllerAdapter mc;

        public SaveAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("save"), new ImageIcon(ControllerAdapter.this.getResource("images/filesave.png")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            this.mc.save();
            ControllerAdapter.this.getFrame().out(ControllerAdapter.this.getText("saved"));
            ControllerAdapter.this.getController().setTitle();
        }
    }

    protected class OpenAction
    extends AbstractAction {
        ControllerAdapter mc;

        public OpenAction(ControllerAdapter modeController) {
            super(ControllerAdapter.this.getText("open"), new ImageIcon(ControllerAdapter.this.getResource("images/fileopen.png")));
            this.mc = modeController;
        }

        public void actionPerformed(ActionEvent e) {
            this.mc.open();
            ControllerAdapter.this.getController().setTitle();
        }
    }

    private class ControllerPopupMenuListener
    implements PopupMenuListener {
        private ControllerPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(false);
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            ControllerAdapter.this.setBlocked(false);
        }
    }

    protected class nodesDepthComparator
    implements Comparator {
        public int compare(Object p1, Object p2) {
            Object[] path2;
            MindMapNode n1 = (MindMapNode)p1;
            MindMapNode n2 = (MindMapNode)p2;
            Object[] path1 = ControllerAdapter.this.getModel().getPathToRoot(n1);
            int depth = path1.length - (path2 = ControllerAdapter.this.getModel().getPathToRoot(n2)).length;
            if (depth > 0) {
                return -1;
            }
            if (depth < 0) {
                return 1;
            }
            if (n1.isRoot()) {
                return 0;
            }
            return n1.getParentNode().getChildPosition(n1) - n2.getParentNode().getChildPosition(n2);
        }
    }
}

