/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.FreemindAction;
import freemind.controller.actions.generated.instance.AddArrowLinkXmlAction;
import freemind.controller.actions.generated.instance.RemoveArrowLinkXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import java.awt.event.ActionEvent;
import javax.xml.bind.JAXBException;

public class RemoveArrowLinkAction
extends FreemindAction
implements ActorXml {
    private MindMapArrowLinkModel mArrowLink;
    private final ModeController controller;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$RemoveArrowLinkXmlAction;

    public RemoveArrowLinkAction(ModeController controller, MindMapArrowLinkModel arrowLink) {
        super("remove_arrow_link", "images/edittrash.png", controller);
        this.controller = controller;
        this.setArrowLink(arrowLink);
        if (arrowLink == null) {
            this.addActor(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.removeReference(this.mArrowLink);
    }

    public void removeReference(MindMapLink arrowLink) {
        this.controller.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.controller.getActionFactory().executeAction(this.getActionPair(arrowLink));
        this.controller.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private ActionPair getActionPair(MindMapLink arrowLink) {
        return new ActionPair(this.createRemoveArrowLinkXmlAction(arrowLink.getUniqueID()), this.createAddArrowLinkXmlAction(arrowLink));
    }

    public MindMapArrowLinkModel getArrowLink() {
        return this.mArrowLink;
    }

    public void setArrowLink(MindMapArrowLinkModel arrowLink) {
        this.mArrowLink = arrowLink;
    }

    public void act(XmlAction action) {
        if (action instanceof RemoveArrowLinkXmlAction) {
            RemoveArrowLinkXmlAction removeAction = (RemoveArrowLinkXmlAction)action;
            MindMapLink arrowLink = this.getLinkRegistry().getLinkForID(removeAction.getId());
            if (arrowLink == null) {
                throw new IllegalArgumentException("Unknown link to id " + removeAction.getId() + " should be deleted.");
            }
            this.getLinkRegistry().deregisterLink(arrowLink);
            this.controller.nodeChanged(arrowLink.getSource());
            this.controller.nodeChanged(arrowLink.getTarget());
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$RemoveArrowLinkXmlAction == null ? (class$freemind$controller$actions$generated$instance$RemoveArrowLinkXmlAction = RemoveArrowLinkAction.class$("freemind.controller.actions.generated.instance.RemoveArrowLinkXmlAction")) : class$freemind$controller$actions$generated$instance$RemoveArrowLinkXmlAction;
    }

    private MindMapLinkRegistry getLinkRegistry() {
        return this.controller.getMap().getLinkRegistry();
    }

    public RemoveArrowLinkXmlAction createRemoveArrowLinkXmlAction(String id) {
        try {
            RemoveArrowLinkXmlAction action = this.controller.getActionXmlFactory().createRemoveArrowLinkXmlAction();
            action.setId(id);
            return action;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public AddArrowLinkXmlAction createAddArrowLinkXmlAction(MindMapLink link) {
        try {
            AddArrowLinkXmlAction action = this.controller.getActionXmlFactory().createAddArrowLinkXmlAction();
            action.setNode(link.getSource().getObjectId(this.controller));
            action.setDestination(link.getTarget().getObjectId(this.controller));
            action.setNewId(link.getUniqueID());
            action.setColor(Tools.colorToXml(link.getColor()));
            if (link instanceof MindMapArrowLink) {
                MindMapArrowLink arrowLink = (MindMapArrowLink)link;
                action.setEndArrow(arrowLink.getEndArrow());
                action.setEndInclination(Tools.PointToXml(arrowLink.getEndInclination()));
                action.setStartArrow(arrowLink.getStartArrow());
                action.setStartInclination(Tools.PointToXml(arrowLink.getStartInclination()));
            }
            return action;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

