/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.FoldAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.xml.bind.JAXBException;

public class ToggleFoldedAction
extends AbstractAction
implements ActorXml {
    private final ControllerAdapter modeController;
    private Logger logger;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$FoldAction;

    public ToggleFoldedAction(ControllerAdapter controller) {
        super(controller.getText("toggle_folded"));
        this.modeController = controller;
        this.modeController.getActionFactory().registerActor(this, this.getDoActionClass());
        this.logger = this.modeController.getFrame().getLogger(this.getClass().getName());
    }

    public void actionPerformed(ActionEvent e) {
        this.toggleFolded();
    }

    public void toggleFolded() {
        this.toggleFolded(this.modeController.getSelecteds().listIterator());
    }

    public void toggleFolded(ListIterator listIterator) {
        boolean fold = this.getFoldingState(this.reset(listIterator));
        CompoundAction doAction = this.createFoldAction(this.reset(listIterator), fold, false);
        CompoundAction undoAction = this.createFoldAction(this.reset(listIterator), !fold, true);
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    ListIterator reset(ListIterator iterator) {
        while (iterator.hasPrevious()) {
            iterator.previous();
        }
        return iterator;
    }

    private boolean getFoldingState(ListIterator iterator) {
        Tools.BooleanHolder state = null;
        boolean allNodeHaveSameFoldedStatus = true;
        ListIterator it = iterator;
        while (it.hasNext()) {
            MindMapNode node = (MindMapNode)it.next();
            if (node.getChildCount() == 0) continue;
            if (state == null) {
                state = new Tools.BooleanHolder();
                state.setValue(node.isFolded());
                continue;
            }
            if (node.isFolded() == state.getValue()) continue;
            allNodeHaveSameFoldedStatus = false;
            break;
        }
        boolean fold = true;
        if (allNodeHaveSameFoldedStatus && state != null) {
            fold = !state.getValue();
        }
        return fold;
    }

    private CompoundAction createFoldAction(ListIterator iterator, boolean fold, boolean undo) {
        try {
            CompoundAction comp = this.modeController.getActionXmlFactory().createCompoundAction();
            MindMapNode lastNode = null;
            ListIterator it = iterator;
            while (it.hasNext()) {
                MindMapNode node = (MindMapNode)it.next();
                FoldAction foldAction = this.createSingleFoldAction(fold, node, undo);
                if (foldAction == null) continue;
                if (!undo) {
                    comp.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(foldAction);
                } else {
                    comp.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(0, foldAction);
                }
                lastNode = node;
            }
            this.logger.finest("Compound contains " + comp.getCompoundActionOrSelectNodeActionOrCutNodeAction().size() + " elements.");
            return comp;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    private FoldAction createSingleFoldAction(boolean fold, MindMapNode node, boolean undo) {
        FoldAction foldAction = null;
        try {
            if ((undo && node.isFolded() == fold || !undo && node.isFolded() != fold) && (node.hasChildren() || Tools.safeEquals(this.modeController.getFrame().getProperty("enable_leaves_folding"), "true"))) {
                foldAction = this.modeController.getActionXmlFactory().createFoldAction();
                foldAction.setFolded(fold);
                foldAction.setNode(this.modeController.getNodeID(node));
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return foldAction;
    }

    public void act(XmlAction action) {
        if (action instanceof FoldAction) {
            FoldAction foldAction = (FoldAction)action;
            NodeAdapter node = this.modeController.getNodeFromID(foldAction.getNode());
            boolean fold = foldAction.isFolded();
            this._setFolded(node, fold);
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$FoldAction == null ? (class$freemind$controller$actions$generated$instance$FoldAction = ToggleFoldedAction.class$("freemind.controller.actions.generated.instance.FoldAction")) : class$freemind$controller$actions$generated$instance$FoldAction;
    }

    public void setFolded(MindMapNode node, boolean folded) {
        FoldAction doAction = this.createSingleFoldAction(folded, node, false);
        FoldAction undoAction = this.createSingleFoldAction(!folded, node, true);
        if (doAction == null || undoAction == null) {
            return;
        }
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private void _setFolded(MindMapNode node, boolean folded) {
        if (node == null) {
            throw new IllegalArgumentException("setFolded was called with a null node.");
        }
        if (node.isRoot() && folded) {
            return;
        }
        if (node.isFolded() != folded) {
            node.setFolded(folded);
            this.modeController.nodeStructureChanged(node);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

