/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.filemode;

import freemind.controller.StructuredMenuHolder;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.actions.NewMapAction;
import freemind.modes.filemode.FileMapModel;
import freemind.modes.filemode.FileNodeModel;
import freemind.modes.filemode.FilePopupMenu;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class FileController
extends ControllerAdapter {
    Action newMap = new NewMapAction(this, this);
    Action center = new CenterAction();
    Action openPath = new OpenPathAction();
    private JPopupMenu popupmenu = new FilePopupMenu(this);

    public FileController(Mode mode) {
        super(mode);
    }

    public MapAdapter newModel() {
        return new FileMapModel(this.getFrame());
    }

    public MindMapNode newNode(Object userObject) {
        return new FileNodeModel((File)userObject, this.getFrame());
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public void updateMenus(StructuredMenuHolder holder) {
        this.add(holder, "menu_bar/edit//find", this.find, "keystroke_find");
        this.add(holder, "menu_bar/edit//findNext", this.findNext, "keystroke_find_next");
        this.add(holder, "menu_bar/edit//openPath", this.openPath, null);
    }

    private class OpenPathAction
    extends AbstractAction {
        OpenPathAction() {
            super(FileController.this.getController().getResourceString("open"));
        }

        public void actionPerformed(ActionEvent e) {
            File newCenter;
            String inputValue = JOptionPane.showInputDialog(FileController.this.getText("open"), (Object)"");
            if (inputValue != null && (newCenter = new File(inputValue)).exists()) {
                FileMapModel map = new FileMapModel(newCenter, FileController.this.getFrame());
                FileController.this.newMap(map);
            }
        }
    }

    private class CenterAction
    extends AbstractAction {
        CenterAction() {
            super(FileController.this.getController().getResourceString("center"));
        }

        public void actionPerformed(ActionEvent e) {
            if (FileController.this.getSelected() != null) {
                FileMapModel map = new FileMapModel(((FileNodeModel)FileController.this.getSelected()).getFile(), FileController.this.getFrame());
                FileController.this.newMap(map);
            }
        }
    }
}

