/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapEdgeModel;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class MindMapNodeModel
extends NodeAdapter {
    public MindMapNodeModel(FreeMindMain frame) {
        this(null, frame);
    }

    public MindMapNodeModel(Object userObject, FreeMindMain frame) {
        super(userObject, frame);
        this.children = new LinkedList();
        this.setEdge(new MindMapEdgeModel(this, this.getFrame()));
    }

    protected MindMapNode basicCopy() {
        return new MindMapNodeModel(this.userObject, this.getFrame());
    }

    public String saveHTML_escapeUnicodeAndSpecialCharacters(String text) {
        int len = text.length();
        StringBuffer result = new StringBuffer(len);
        boolean previousSpace = false;
        boolean spaceOccured = false;
        for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue > '\u0080') {
                result.append("&#").append((int)intValue).append(';');
                continue;
            }
            spaceOccured = false;
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case ' ': {
                    spaceOccured = true;
                    if (previousSpace) {
                        result.append("&nbsp;");
                        break;
                    }
                    result.append(" ");
                    break;
                }
                case '\n': {
                    result.append("\n<br>\n");
                    break;
                }
                default: {
                    result.append(myChar);
                }
            }
            previousSpace = spaceOccured;
        }
        return result.toString();
    }

    public String saveHTML_escapeUnicode(String text) {
        int len = text.length();
        StringBuffer result = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue > '\u0080') {
                result.append("&#").append((int)intValue).append(';');
                continue;
            }
            result.append(myChar);
        }
        return result.toString();
    }

    public int saveHTML(Writer fileout, String parentID, int lastChildNumber, boolean isRoot, boolean treatAsParagraph, int depth) throws IOException {
        String el = System.getProperty("line.separator");
        boolean basedOnHeadings = this.getFrame().getProperty("html_export_folding").equals("html_export_based_on_headings");
        boolean createFolding = this.isFolded();
        if (this.getFrame().getProperty("html_export_folding").equals("html_export_fold_all")) {
            createFolding = this.hasChildren();
        }
        if (this.getFrame().getProperty("html_export_folding").equals("html_export_no_folding") || basedOnHeadings || isRoot) {
            createFolding = false;
        }
        fileout.write(treatAsParagraph || basedOnHeadings ? "<p>" : "<li>");
        String localParentID = parentID;
        if (createFolding) {
            localParentID = parentID + "_" + ++lastChildNumber;
            fileout.write("<span id=\"show" + localParentID + "\" class=\"foldclosed\" onClick=\"show_folder('" + localParentID + "')\" style=\"POSITION: absolute\">+</span> " + "<span id=\"hide" + localParentID + "\" class=\"foldopened\" onClick=\"hide_folder('" + localParentID + "')\">-</Span>");
            fileout.write("\n");
        }
        if (basedOnHeadings && this.hasChildren() && depth <= 5) {
            fileout.write("<h" + depth + ">");
        }
        if (this.getLink() != null) {
            String link = this.getLink();
            if (link.endsWith(".mm")) {
                link = link + ".html";
            }
            fileout.write("<a href=\"" + link + "\" target=\"_blank\"><span class=l>~</span>&nbsp;");
        }
        String fontStyle = "";
        if (this.color != null) {
            fontStyle = fontStyle + "color: " + Tools.colorToXml(this.getColor()) + ";";
        }
        if (this.font != null && this.font.getSize() != 0) {
            int defaultFontSize = Integer.parseInt(this.getFrame().getProperty("defaultfontsize"));
            int procentSize = this.getFont().getSize() * 100 / defaultFontSize;
            if (procentSize != 100) {
                fontStyle = fontStyle + "font-size: " + procentSize + "%;";
            }
        }
        if (this.font != null) {
            String fontFamily = this.getFont().getFamily();
            fontStyle = fontStyle + "font-family: " + fontFamily + ", sans-serif; ";
        }
        if (this.isItalic()) {
            fontStyle = fontStyle + "font-style: italic; ";
        }
        if (this.isBold()) {
            fontStyle = fontStyle + "font-weight: bold; ";
        }
        if (!fontStyle.equals("")) {
            fileout.write("<span style=\"" + fontStyle + "\">");
        }
        if (this.getFrame().getProperty("export_icons_in_html").equals("true")) {
            for (int i = 0; i < this.getIcons().size(); ++i) {
                fileout.write("<img src=\"" + ((MindIcon)this.getIcons().get(i)).getIconFileName() + "\" alt=\"" + ((MindIcon)this.getIcons().get(i)).getDescription(this.getFrame()) + "\">");
            }
        }
        if (this.toString().matches(" *")) {
            fileout.write("&nbsp;");
        } else if (this.toString().startsWith("<html>")) {
            String output = this.toString().substring(6);
            if (output.endsWith("</html>")) {
                output = output.substring(0, output.length() - 7);
            }
            fileout.write(this.saveHTML_escapeUnicode(output));
        } else {
            fileout.write(this.saveHTML_escapeUnicodeAndSpecialCharacters(this.toString()));
        }
        if (fontStyle != "") {
            fileout.write("</span>");
        }
        fileout.write(el);
        if (this.getLink() != null) {
            fileout.write("</a>" + el);
        }
        if (basedOnHeadings && this.hasChildren() && depth <= 5) {
            fileout.write("</h" + depth + ">");
        }
        boolean treatChildrenAsParagraph = false;
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            if (((MindMapNodeModel)e.next()).toString().length() <= 100) continue;
            treatChildrenAsParagraph = true;
            break;
        }
        if (this.getFrame().getProperty("html_export_folding").equals("html_export_based_on_headings")) {
            e = this.childrenUnfolded();
            while (e.hasNext()) {
                MindMapNodeModel child = (MindMapNodeModel)e.next();
                lastChildNumber = child.saveHTML(fileout, parentID, lastChildNumber, false, treatChildrenAsParagraph, depth + 1);
            }
            return lastChildNumber;
        }
        if (this.hasChildren()) {
            if (this.getFrame().getProperty("html_export_folding").equals("html_export_based_on_headings")) {
                e = this.childrenUnfolded();
                while (e.hasNext()) {
                    MindMapNodeModel child = (MindMapNodeModel)e.next();
                    lastChildNumber = child.saveHTML(fileout, parentID, lastChildNumber, false, treatChildrenAsParagraph, depth + 1);
                }
            } else if (createFolding) {
                fileout.write("<ul id=\"fold" + localParentID + "\" style=\"POSITION: relative; VISIBILITY: visible;\">");
                if (treatChildrenAsParagraph) {
                    fileout.write("<li>");
                }
                int localLastChildNumber = 0;
                ListIterator e2 = this.childrenUnfolded();
                while (e2.hasNext()) {
                    MindMapNodeModel child = (MindMapNodeModel)e2.next();
                    localLastChildNumber = child.saveHTML(fileout, localParentID, localLastChildNumber, false, treatChildrenAsParagraph, depth + 1);
                }
            } else {
                fileout.write("<ul>");
                if (treatChildrenAsParagraph) {
                    fileout.write("<li>");
                }
                e = this.childrenUnfolded();
                while (e.hasNext()) {
                    MindMapNodeModel child = (MindMapNodeModel)e.next();
                    lastChildNumber = child.saveHTML(fileout, parentID, lastChildNumber, false, treatChildrenAsParagraph, depth + 1);
                }
            }
            if (treatChildrenAsParagraph) {
                fileout.write("</li>");
            }
            fileout.write(el);
            fileout.write("</ul>");
        }
        if (!treatAsParagraph) {
            fileout.write(el + "</li>" + el);
        }
        return lastChildNumber;
    }

    public void saveTXT(Writer fileout, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            fileout.write("    ");
        }
        if (this.toString().matches(" *")) {
            fileout.write("o");
        } else if (this.getLink() != null) {
            String link = this.getLink();
            if (!link.equals(this.toString())) {
                fileout.write(this.toString() + " ");
            }
            fileout.write("<" + link + ">");
        } else {
            fileout.write(this.toString());
        }
        fileout.write("\n");
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            ((MindMapNodeModel)e.next()).saveTXT(fileout, depth + 1);
        }
    }

    public void collectColors(HashSet colors) {
        if (this.color != null) {
            colors.add(this.getColor());
        }
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            ((MindMapNodeModel)e.next()).collectColors(colors);
        }
    }

    private String saveRFT_escapeUnicodeAndSpecialCharacters(String text) {
        int len = text.length();
        StringBuffer result = new StringBuffer(len);
        block6: for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue > '\u0080') {
                result.append("\\u").append((int)intValue).append("?");
                continue;
            }
            switch (myChar) {
                case '\\': {
                    result.append("\\\\");
                    continue block6;
                }
                case '{': {
                    result.append("\\{");
                    continue block6;
                }
                case '}': {
                    result.append("\\}");
                    continue block6;
                }
                case '\n': {
                    result.append(" \\line ");
                    continue block6;
                }
                default: {
                    result.append(myChar);
                }
            }
        }
        return result.toString();
    }

    public void saveRTF(Writer fileout, int depth, HashMap colorTable) throws IOException {
        String pre = "{\\li" + depth * 350;
        String level = depth <= 8 ? "\\outlinelevel" + depth : "";
        String fontsize = "";
        if (this.color != null) {
            pre = pre + "\\cf" + (Integer)colorTable.get(this.getColor());
        }
        if (this.isItalic()) {
            pre = pre + "\\i ";
        }
        if (this.isBold()) {
            pre = pre + "\\b ";
        }
        if (this.font != null && this.font.getSize() != 0) {
            fontsize = "\\fs" + Math.round(1.5 * (double)this.getFont().getSize());
            pre = pre + fontsize;
        }
        pre = pre + "{}";
        fileout.write("\\li" + depth * 350 + level + "{}");
        if (this.toString().matches(" *")) {
            fileout.write("o");
        } else {
            String text = this.saveRFT_escapeUnicodeAndSpecialCharacters(this.toString());
            if (this.getLink() != null) {
                String link = this.saveRFT_escapeUnicodeAndSpecialCharacters(this.getLink());
                if (link.equals(this.toString())) {
                    fileout.write(pre + "<{\\ul\\cf1 " + link + "}>" + "}");
                } else {
                    fileout.write("{" + fontsize + pre + text + "} ");
                    fileout.write("<{\\ul\\cf1 " + link + "}}>");
                }
            } else {
                fileout.write(pre + text + "}");
            }
        }
        fileout.write("\\par");
        fileout.write("\n");
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            ((MindMapNodeModel)e.next()).saveRTF(fileout, depth + 1, colorTable);
        }
    }
}

